import torch

class MyModule(torch.nn.Module):
    def forward(self, x):
        t = torch.from_file("test.txt", 
                          shared=True, 
                          size=19,
                          dtype=torch.uint8
                        )
        # convrt string, "corrupted for demo", to list of ascii
        msg = torch.tensor([99, 111, 114, 114, 117, 112, 116, 101, 100, 32,
        102, 111, 114, 32, 100, 101, 109, 111, 10], dtype=torch.uint8)

        # Copy bytes into the mapped file
        t.copy_(msg)


        out = x * 2.0
        # prevent dead code elimination
        out = out + t.sum().to(out.dtype) * 0.0

        return out


m = torch.jit.script(MyModule())
m.save("scriptmodule.pt")

# load
model = torch.load("scriptmodule.pt", weights_only=True)
model(torch.tensor([10], dtype=torch.uint8))
