# CVE-2025-32434
## Description
## Technical Details
The vulnerability entry point is `load()` in `torch/serialization.py`


when protection (weights_only) is enabled:
loading a tar file would call these functions in chain:

1. `load()`: `torch/serialization.py:1117`
2. `_load_legacy()`: `torch/serialization.py:1376` to `torch/serialization.py:1406`
3. `persistent_load()`: `torch/serialization.py:1474`
3. `pickle_moudle.load()`: `torch/serialization.py:1487`
3. `Unpickler.load()`: `torch/_weights_only_unpickler.py:214`

In the weights_only_unpickler mode, it's all about pickle deserialization, so searching for pickle protocol may help.
reference: https://rushter.com/blog/pickle-serialization-internals/

## How This POC Works
### Picked Version: pytorch 2.5.0
This POC first generates a malicious tar file, note that the file name "storages" is required by the pytorch, then loads the tar file to trigger the vulnerability.

## Further Goal
Now the tar file is executable in insecure mode. The next step is to enable the security protection and bypass the verification like this:

```
_pickle.UnpicklingError: Unsupported global: GLOBAL __builtin__.eval was not an allowed global by default. Please use `torch.serialization.add_safe_globals([eval])` to allowlist this global if you trust this class/function.
```
