from flask import Flask, request
import datetime

app = Flask(__name__)

@app.route('/report', methods=['POST'])
def report():
    data = request.get_data(as_text=True)
    timestamp = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
    print(f"[{timestamp}] Bot reported in: {data}")
    with open("log.txt", "a") as f:
        f.write(f"[{timestamp}] {data}\n")
    return "ACK", 200

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=8080)
