# CVE-2025-32429 XWiki SQL Injection PoC

**Author:** Byte Reaper  
**Telegram:** [@ByteReaper0](https://t.me/ByteReaper0)  
**CVE:** CVE‑2025‑32429  
**Vulnerability:** Blind SQL Injection in XWiki LiveData REST API  
**Affected File:** `getdeleteddocuments.vm` (sort parameter)

---

##  Description : 

A blind SQL Injection vulnerability exists in XWiki Platform’s LiveData REST endpoint when using the `sort` parameter in `getdeleteddocuments.vm`. An attacker can inject arbitrary SQL fragments, leveraging time‐based payloads (`SLEEP`) or union‐based queries to enumerate database contents.

This repository provides a C-based Proof‑of‑Concept that:

1. Detects WAF/rate‑limiter interference before exploitation.  
2. Iterates a set of SQLi payloads (boolean, time‑based).  
3. Measures response time and searches for indicative keywords.  
4. Prints out any extracted evidence of vulnerability.

---

##  Requirements

- Linux x86_64  
- GCC 
- [libcurl](https://curl.se/libcurl/) development headers  
- [argparse](https://github.com/cofyc/argparse) C library  

---

Compile:

gcc  -o exploit exploit.c argparse.c -lcurl 
## Usage

./exploit -u <BASE_URL> [-c cookies.txt] [-v]
-u, --url : Base URL of target XWiki instance

-c, --cookies : (Optional) Path to cookie jar for authenticated sessions

-v, --verbose : Enable verbose debug output

Examples
Unauthenticated test against public instance

./exploit -u http://victim.com
Using cookies for authenticated context

./exploit -u https://intranet.xwiki.local -c session.txt -v
## Workflow:

WAF Detection

Sends a benign payload with User-Agent: sqlmap

Checks for blocking HTTP codes (403/404/503), unusual redirects, time‑delays, signature keywords in response, and connection resets

Exploit Loop

Iterates through predefined SQL payloads: boolean checks, SLEEP() injections, union queries

Measures total request time (CURLINFO_TOTAL_TIME) to detect time‑based injection

Searches response body for SQL keywords (select, union, etc.) to confirm injection success

## Mitigation : 
Upgrade XWiki to a version where getdeleteddocuments.vm properly sanitizes the sort parameter.

Apply parameterized queries or whitelist allowable sort fields.

Deploy a WAF or input‐validation layer that normalizes and rejects unexpected SQL metacharacters in parameters.

## License : 
MIT


