
# 🚀 CVE-2025-32118 - WordPress CMP Plugin RCE Exploit

🔍 **Title:** WordPress CMP – Coming Soon & Maintenance plugin <= 4.1.13 - Remote Code Execution (RCE)  
🗓️ **Published:** 2025-04-04   
🔐 **CWE:** CWE-434 - Unrestricted Upload of File with Dangerous Type  
📊 **CVSS:** 9.1 (CRITICAL) — CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H

---

## 📜 Description

A critical **Remote Code Execution** (RCE) vulnerability exists in the **CMP – Coming Soon & Maintenance** plugin for WordPress (<= 4.1.13).  
This flaw allows an **authenticated admin user** to upload malicious ZIP files containing executable PHP shells, leading to **full site compromise**.

---

## 💥 Impact

- Upload of arbitrary PHP code inside the plugin directory
- Unrestricted execution of system commands via web shell
- Potential full server takeover

---

## ⚙️ Requirements

- WordPress site with vulnerable CMP plugin installed (`<= 4.1.13`)
- Valid WordPress admin credentials (Authentication Required)

---

## 💻 Usage

```bash
python3 CVE-2025-32118.py -u http://target-site.com/wordpress -un admin -p password
```

## ✍️ Usage (CLI Help Output)

```
usage: CVE-2025-32118.py [-h] -u URL -un USERNAME -p PASSWORD
Exploit For CVE-2025-32118 : By Nxploited - Khaled Alenazi

options:
  -h, --help            show this help message and exit
  -u, --url URL         Base URL of WordPress site
  -un, --username USERNAME   Admin username
  -p, --password PASSWORD    Admin password
```

---



### 📌 Arguments:

| Flag       | Description                    |
|------------|--------------------------------|
| `-u`       | Base URL of WordPress site     |
| `-un`      |       username                 |
| `-p`       |       password                 |

---

## 🧪 What it does:

1. Authenticates to the WordPress admin panel.
2. Fetches a valid `nonce` for upload request.
3. Creates a malicious ZIP with:
   - `style.css` (valid theme format)
   - `nxploitedshell.php` (RCE payload)
4. Uploads the ZIP using the vulnerable theme upload functionality.
5. Verifies the shell by executing `?cmd=whoami`.

---

## 📂 Shell Location

Once uploaded successfully, the shell will be located at:

```
/wp-content/plugins/cmp-premium-themes/nxploitedshell/nxploitedshell.php
```

Test it via:

```bash
http://target-site.com/wp-content/plugins/cmp-premium-themes/nxploitedshell/nxploitedshell.php?cmd=id
```

---

## ❗ Disclaimer

> This exploit is for **educational purposes** only.  
> Unauthorized use of this code **against systems you don't own** is illegal and unethical.

---

## 🔗 Reference

- [CVE-2025-32118 on MITRE](https://cve.mitre.org/)
- CWE-434: [https://cwe.mitre.org/data/definitions/434.html](https://cwe.mitre.org/data/definitions/434.html)

---

## ✒️ By:
*Nxploited | Khaled Alenazi*
