Question 1. You have received automated alerts from your SCA tool that a rather large number of your services have new critical findings. A new critical CVE has been published and according to your SCA tool a vulnerable version is present in many of your services since they share a common codebase.

1. You may select any critical rated CVE for an open source library and create details of the services as needed.
2. Write an internal Security Advisory which you would use to communicate effectively about this vulnerability with engineering teams. These teams are scattered across multiple time zones and countries and will rely primarily on this advisory to take action. 
This should not be just a copy and paste from the vulnerability/CVE description, though you may quote and reference portions of that description.

You should include:-
1. Steps/Criteria to determine if each service is vulnerable beyond the vulnerable library being present in the service’s inventory.
2. Potential Impact(s)
3. Preferred Remediation method(s)
4. Compensating Controls if the preferred remediation method cannot be completed within Critical SLA
5. Other information you determine necessary, links to or descriptions of proof of concept code/methods, Indicators of Attack/Compromise, etc.

Answer of question 1:-

CVE Summary:-

The CVE selected is :- CVE-2025-32013

CVE publication Date:- 2025-04-06

CVSS V4 base score:- 9.3

Severity:- Critical

Product Type:- Open Source


CVE Descriptions:- Server Side Request Forger Attack is found LNbits is a Lightning wallet and accounts system. LNbits, free and open-source Lightning Network wallet/accounts system developed on python. This sits on top of any funding source used for:
1. Accounts system to mitigate the risk of exposing applications to your full balance, via unique API keys for each wallet
2. Extendable platform for exploring Lightning Network functionality via LNbits extension framework
3. Part of a development stack via LNbits API
4. Fallback wallet for the LNURL scheme
5. Instant wallet for LN demonstrations
   
     The vulnerability is observed in the httpx library of “LNURL-auth that is a generic authentication protocol”. This protocol performs the AuthN mechanism using a digital signature. After the user is authenticated without revealing the actual login credentials (such as username, password, emailed etc) a signed unique key will be generated for each domain followed by a callback URL with the name LNURL-auth handler 

     When processing LNURL authentication requests which is browser redirect intermediate request, the application component/module that is “LN SERVICE” accepts a callback URL parameter along with the unique “LinkingKey” derived during AuthN and makes an HTTP request to that URL using the httpx library with redirect following enabled by default in the module “LN SERVICE”. The application doesn't properly validate the callback URL (such as https://10.10.1.2), allowing attackers to specify internal network addresses and access internal resources and its context path. Thus it leads to RCE, RFI, LFI attack.

     Steps/Criteria to determine if each service is vulnerable beyond the vulnerable library being present in the service’s inventory:- The <hiring Company> is a bank that uses wallet through Open Banking concepts. This needs seem less AuthN/AuthZ framework like OAUTH 2.0. Other business need is the consuming third party client application, mobile app user, enterprise user, teller machine in the private network etc uses “LNURL-auth protocol” through a centralised webserver hosted on the bank side publicly accessible and also accessible through teller machine to connect the webserver before allowing any user operations. This teller machine seat behind the firewall or restricted VPN subnet allocated for teller machine that also uses the same protocol.

     The Data Flow Diagram (DFD) of the hypnotical business use case is as follows that will highlight how the attack is possible in our environment with the existing service that is vulnerable of SSRF attack.

     Thus from the DFD it is clear that our organization is using this unified AuthN/AuthZ module “LNURL-auth protocol” hosted on the Centralised Webserver that is connected by all the calling application over internet and private network. Behind the firewall within the private network the internal isolated app server that is 10.10.1.2 is hosted on the separate network segment.

     The vulnerable centralised Bank webserver (10.10.1.1) subnet by default have mTLS enabled to AuthN with least access permission granted as zero trust network to access the internal system (10.10.1.2) network. This system is not accessible from the internet directly to any external users and from the intranet/private network directly from any enterprise end-users until allowed. Also as per business use need vulnerable centralised Bank webserver (10.10.1.1) do not have any engagement with isolated internal server 10.10.1.2.

  Follow the link for image: [03_Communication_Flow_Diagram.jpg](https://github.com/Mohith-T/CVE-2025-32013/blob/main/03_Communication_Flow_Diagram.jpg)
  
  The communication flow goes like this way:-
  

  1a. The teller machine & the enterprise application sends the LNURL AUTNN request over the corporate VPNN connection or/& P-2-P connection

  1b. The client app users and mobile app users of the bank sends the LNURL AUTHN request over the internet

Load Balancer (LB) accepts the request and does the SSL offloading

  2. The LB sends both (1a and 1b) LNRUL AUTHN request to the centralised bank webserver.

  4. The centralised bank webserver process the request using LNURL-AUTHN protocol and its methods

  5. It generates the CALLBACK_URRL and LinkingKey for each client uniquely

  3. Centralised bank webserver sends the response along with CALLBACK_URL and LinkingKey to 1a and 1b clients

  6. The client application users and the mobile application users of the bank sends the intermediate LNURL AUTNN request along with CALLBACK_URL and linkingKey to the LB

  7. The teller machine & the enterprise application sends the intermediate LNURL AUTNN request along with CALLBACK_URL and linkingKey to the LB

Load Balancer (LB) accepts the request and does the SSL offloading

  2. The Load Balancer (LB) sends both (6 & 7) intermediate browser redirected LNURL AUTNN request along with CALLBACK_URL and linkingKey to the centralised bank webserver

  8. The centralised webserver sends the user crafted CALLBACK_URL pointing to 10.10.1.2 directly without doing the URL, URI, PATH & context validations leads to unauthorised access to internal isolated server behind the firewall. This leads to SSRF attack that results in RCE, LFI, RFI threat

Potential Impact(s):-

1. Unauthorised access to the private network system
2. Unauthenticated access of the users leads to user impersonation threat
3. Getting hold of sensitive data of system and customers
4. This leads to data privacy, data protection breach
5. Unwanted data tempering and manipulation leads to data integrity violations
6. SSRF leads to RCE, RFI, LFI that exploits to system takeover (full or partial)
7. Environment mapping and structure will be enumerated to the external unauthorised users
8. The attacker can work in silo by keeping no trace to the target impacted server

Preferred Remediation method(s):-

1. Application layer control
2. Open redirect validations should be done both at client and server side
3. The httpx library of the open source python module should be patched by the vendor
4. User provided URI, URL, context path etc should be mapped with allowed white list domain, pattern, path, regex etc check
5. User request or any API endpoint call should ne AuthN/AuthZ at multiple layers in the DFD using least access permission or deny completely with IAM control
6.Malicious data should be validated for genuine request and active login valid user request to prevent RCE, LFI, RGI attack
7. Custom error message with static error code should be generated with less of data revealing
8. Sensitive data should be dropped, masked
9. CORS should be enabled to allow CORS request from the browser
10. SAST, SCA tool should be integrated in the S-SDLC phase to identify the vulnerability through automated scan
11. The user activities along with timestamp should be maintained that triggers CALLBACK_URL request to the backend server that is 10.10.1.2. This will reduce the repudiation threat

Network layer control:-

1. Security list and NSG should be defined
2. Allowed port should be accessible and keep all other close and deny
3. Firewall should be enabled with allowed security policies
4. WAF should validate the malicious payloads
5. NIDS should be enabled to validate the malicious blocked link to be called
6. TAG should generate in the response body
7. CORP/SERVICE gateway should validate the INGRESS call and EGRESS call

Perimeter level control:-

1. SIEM, SOAR, DART, SOC should be integrated as per the above rule engine
2. AV check should be done in all DFD components
3. HIDS, NIDS should be integrated with updated policies in the end-user system, servers etc
4. DLP should have policies that won’t allow the system data to leave the network over response

Compensating Controls if the preferred remediation method cannot be completed within Critical SLA:-

1. Application level rule engine should be set
2. The CORP gateway, firewall, security list, NSG, ACL policies should be default set to DENY until explicitly allowed by IAM policies at runtime TOCTOU call
3. The unwanted ports in the backend server should be disabled and closed

Other information you determine necessary, links to or descriptions of proof of concept code/methods, Indicators of Attack/Compromise, etc. :-

Resources:- 

https://nvd.nist.gov/vuln/detail/CVE-2025-32013

https://github.com/lnurl/luds/blob/luds/04.md
