# TomcatKiller - CVE-2025-31650

🚨 Proof of Concept (PoC) for Apache Tomcat HTTP/2 DoS vulnerability (CVE-2025-31650)

This script triggers a memory exhaustion condition in Apache Tomcat by sending malformed `priority` headers over HTTP/2.

---

## 🎯 Affected Versions

- Apache Tomcat 9.0.76 – 9.0.102
- Apache Tomcat 10.1.10 – 10.1.39
- Apache Tomcat 11.0.0-M2 – 11.0.5

---

## ⚙️ Features

- ✔️ HTTP/2 support verification
- ✔️ `Server` header inspection (detect Tomcat)
- ✔️ `--check-only` mode (non-intrusive)
- ✔️ Async-based scalable exploit with adjustable intensity

---

## 🚀 Usage

### ✅ Check-only (safe detection)
```bash
python3 tomcatkiller.py --target https://example.com:8443 --check-only
```

### 💥 Exploit (DoS)
```bash
python3 tomcatkiller.py --target https://example.com:8443 --exploit --tasks 50 --requests 5000
```

---

## 🧩 Arguments

| Parameter         | Description                                           |
|-------------------|-------------------------------------------------------|
| `--target`        | Full target URL with protocol and port               |
| `--check-only`    | Only test if the server supports HTTP/2 & Tomcat     |
| `--exploit`       | Run the actual DoS attack                            |
| `--tasks`         | Number of async tasks (default: 50)                  |
| `--requests`      | Requests per task (default: 5000)                    |

---

## ⚠️ Disclaimer

This PoC is for educational and authorized security testing **only**.  
Do **not** use it against systems without explicit permission.

---

## 🙏 Credits

- Original concept: [@absholi7ly](https://github.com/absholi7ly/TomcatKiller-CVE-2025-31650)  
- Updated CLI version: [@tunahantekeoglu](https://github.com/tunahantekeoglu)


