# LICENSE

## Security Research License for PDF417 AAMVA Validation Vulnerability Documentation

Copyright © 2025 Cole Leavitt. All rights reserved.

**IMPORTANT NOTICE**: This software and associated documentation ("the Materials") constitute formal security research into critical vulnerabilities in identification systems. These Materials are provided solely for the purposes of **ACADEMIC RESEARCH, SECURITY ANALYSIS, AND VULNERABILITY DISCLOSURE** under the strict terms enumerated below.

### 1. Authorized Uses

The recipient is granted a limited, non-transferable right to use the Materials exclusively for:

- Security vulnerability research and documentation
- Educational demonstration of verification system weaknesses
- Responsible disclosure to affected vendors and security researchers
- Academic analysis of identification validation methodologies

### 2. Prohibited Activities

The Materials shall under no circumstances be used for:

- Development of fraudulent identification instruments
- Circumvention of legal identity verification systems
- Identity misrepresentation or impersonation
- Any activity violating local, state, federal, or international law
- Commercial exploitation without explicit written permission

### 3. Research Integrity Requirements

Any demonstration or testing must:

- Utilize exclusively fictional or synthetic personal data
- Clearly and prominently identify all generated artifacts as "SECURITY RESEARCH SAMPLE - NOT VALID IDENTIFICATION"
- Maintain strict separation from legitimate identification document formats
- Document all testing methodologies and findings comprehensively

### 4. Attribution and Distribution

Any reproduction, distribution, or derivative work must:

- Maintain this complete license text
- Provide full attribution to the original researcher
- Include comprehensive documentation of the vulnerability being demonstrated
- Provide contact information for responsible disclosure procedures
- Maintain all disclaimers and warnings

### 5. Security Research Commitment

The author is committed to coordinated vulnerability disclosure according to industry best practices. Recipients discovering additional vulnerabilities or applications are strongly encouraged to contact affected vendors before public disclosure.

## Disclaimer of Warranties and Limitation of Liability

THE MATERIALS ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS, COPYRIGHT HOLDERS, OR CONTRIBUTORS BE LIABLE FOR ANY CLAIM, DAMAGES, OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT, OR OTHERWISE, ARISING FROM, OUT OF, OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.

## Vulnerability Disclosure

This project documents critical security vulnerabilities in PDF417 barcode validation processes implemented by various identification verification systems. These Materials are disclosed as part of a formal responsible disclosure process to:

1. Properly document the vulnerabilities for affected vendors
2. Provide a verifiable proof-of-concept for security researchers and system maintainers
3. Advance the state of security in identity verification technologies
4. Encourage implementation of proper validation controls in critical security systems

## Affected Systems

The documented vulnerabilities affect the following identity verification products and systems so far tested:

1. **TokenWorks Product Line**:
   - IDentiFake Plus
   - AgeVisor Series
   - IDVisor Series
   - IDVisor Sentry

2. **IDScan.net Systems**:
   - VeriScan
   - VSCloud

3. **State Government Applications**:
   - Missouri ShowMeID

The vulnerability permits the generation of synthetic barcodes that bypass standard validation checks, potentially affecting any system that utilizes these products for identity verification or authentication purposes.

## Contact Information

For academic inquiry, vulnerability disclosure coordination, or security concerns:
- Email: cole@unwrap.rs
- GitHub: github.com/coleleavitt
- LinkedIn: linkedin.com/in/coleleavitt

## CVE Reference
This vulnerability has been assigned CVE ID: CVE-2025-31336 & CVE-2025-31337