# CVE-2025-31133 PoC Exploit

This document explains the functionality of the provided Proof-of-Concept (PoC) script for the `runc` vulnerability CVE-2025-31133.

## Summary

*   **Vulnerability:** CVE-2025-31133 - A symbolic link race condition in `runc`'s `maskedPaths` handling.
*   **Impact:** A malicious container can bypass the protections of `maskedPaths`, allowing it to write to sensitive files on the host system. This constitutes a **container escape**.
*   **PoC Goal:** To safely demonstrate the vulnerability by modifying the host's `/proc/sys/kernel/core_pattern` file from within a container.
*   **Safety:** This PoC is non-destructive. It only writes the string `"pwned"` to the target file and does **not** execute arbitrary code on the host. It also provides instructions to restore the original value.

---

## Vulnerability Explained

The `maskedPaths` feature in a container's OCI specification (`config.json`) is a security mechanism designed to prevent containers from accessing sensitive system files. It works by bind-mounting `/dev/null` (an empty device file) over these sensitive paths inside the container, effectively making them unreadable and unwritable.

The vulnerability (CVE-2025-31133) is a **Time-of-Check to Time-of-Use (TOCTOU)** race condition. The exploit works as follows:

1.  **The Flaw:** When `runc` sets up the container, it prepares to use the `dev/null` file from the container's rootfs as the source for the bind mount that will mask the sensitive path (e.g., `/proc/sys/kernel/core_pattern`).
2.  **The Race:** There is a small window of time between when `runc` resolves the path to `rootfs/dev/null` and when it actually performs the mount operation.
3.  **The Exploit:** An attacker can create a script on the host that continuously and very rapidly swaps the `rootfs/dev/null` file between a legitimate device node and a symbolic link pointing to the target file on the host (`/proc/sys/kernel/core_pattern`).
4.  **Winning the Race:** If the timing is perfect, `runc` will perform its mount operation at the exact moment when `rootfs/dev/null` is a symlink. This causes the kernel to follow the symlink, and the intended masking operation fails for `/proc/sys/kernel/core_pattern`.
5.  **Container Escape:** Because the masking failed, the path inside the container is no longer protected. A process running inside the container can now write to `/proc/sys/kernel/core_pattern`, which directly modifies the host's file, achieving a container escape.

This PoC uses this technique to write to `/proc/sys/kernel/core_pattern`, a common target for such exploits because modifying it can lead to arbitrary code execution on the host when a process crashes. However, this PoC only writes a harmless string to prove the write primitive exists.

---

## How the PoC Script Works

The `poc.sh` script automates the entire process described above.

1.  **Setup & Cleanup:**
    *   It defines variables for the `runc` binary, container name, and rootfs path.
    *   It includes a robust `cleanup` function that ensures any previously created containers or files from the script are removed. This function is automatically called on exit, interruption, or termination.

2.  **Preparation:**
    *   It saves the original content of the host's `/proc/sys/kernel/core_pattern` to a temporary file. This is used later to verify if the exploit succeeded and to help the user restore the system.
    *   It creates a minimal container rootfs (`./rootfs`) and a `config.json` file.
    *   The `config.json` explicitly lists `/proc/sys/kernel/core_pattern` under `maskedPaths`—the very feature the exploit aims to bypass.

3.  **The Race Function (`symlink_race`)**
    *   This is the core of the exploit. It is designed to run in the background.
    *   It enters a tight loop that lasts for 20 seconds.
    *   Inside the loop, it repeatedly:
        1.  Deletes `rootfs/dev/null`.
        2.  Creates a **symbolic link** from `rootfs/dev/null` to the target host file (`/proc/sys/kernel/core_pattern`).
        3.  Pauses for a tiny fraction of a second (500 microseconds).
        4.  Deletes the symlink.
        5.  Recreates `rootfs/dev/null` as a proper **character device** (`mknod`).
        6.  Pauses for a slightly longer time (5000 microseconds).
    *   This rapid switching creates the window of opportunity for the race condition to occur.

4.  **Execution:**
    *   The `symlink_race` function is started as a background process.
    *   Immediately after, the script executes `runc run ...` to create and start the container. This is when `runc` will attempt to apply the `maskedPaths`.
    *   Once the container is running, the script uses `runc exec` to execute a command *inside* the container: `echo 'pwned' > /proc/sys/kernel/core_pattern`.

5.  **Verification:**
    *   The script waits for the background race process to finish and cleans up the container.
    *   It then reads the current content of the host's `/proc/sys/kernel/core_pattern`.
    *   It compares the current content with the expected `"pwned"` string and the original value.
    *   Based on the result, it prints a clear **`[+] EXPLOIT SUCCEEDED!`** or **`[-] Exploit did not succeed.`** message.

---

## Usage

**Prerequisites:**
*   A vulnerable version of `runc`.
*   `busybox-static` installed (for the container's shell).
*   Root privileges (`sudo`) to run `runc` and modify `/proc`.

**Steps:**
1. Save the script as `poc.sh`.
2. Make it executable: `chmod +x poc.sh`.
3. Run it with sudo: `sudo ./poc.sh`.

### Interpreting the Output

*   **Success:** If you see the `[+] EXPLOIT SUCCEEDED!` message, it means the race condition was won. The host's `/proc/sys/kernel/core_pattern` was successfully modified from within the container, confirming the vulnerability.
*   **Failure:** If you see `[-] Exploit did not succeed.`, the race was not won on this attempt. Race conditions are probabilistic and depend heavily on system timing and load. **Try running the script a few more times.**

### Restoring Your System (After a Successful Run)

The PoC will modify a system file. To restore it to its original state, run the command suggested by the script:

```bash
# The 'ORIGINAL_PATTERN' will be the actual value from your system
echo 'original_core_pattern_value' | sudo tee /proc/sys/kernel/core_pattern
```