# Exploit for CVE-2025-30911 – WordPress RomethemeKit <= 1.5.4

This script exploits a **critical vulnerability** in the **RomethemeKit For Elementor WordPress plugin (<= v1.5.4)** that allows **authenticated arbitrary plugin installation and activation**, potentially leading to **Remote Code Execution (RCE)**.

---

## 🛠️ Vulnerability Summary

- **CVE ID**: CVE-2025-30911  
- **Plugin**: RomethemeKit For Elementor  
- **Affected Versions**: <= 1.5.4  
- **Vulnerability Type**: Arbitrary Plugin Installation & Activation → RCE  
- **CWE**: [CWE-94: Improper Control of Generation of Code](https://cwe.mitre.org/data/definitions/94.html)  
- **CVSS Score**: 9.9 (Critical)  
  `CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H`

The vulnerability allows an authenticated attacker (with Administrator access) to programmatically install and activate any plugin — including potentially malicious ones — which may lead to full code execution on the server.

---

## 🚀 Features

- ✅ Auto-detects plugin version to confirm vulnerability.
- ✅ Authenticates using valid admin credentials.
- ✅ Installs and activates any WordPress plugin using the vulnerable AJAX endpoint.
---

## ⚙️ Usage

```bash
python3 CVE-2025-30911.py -u http://target/wordpress -un admin -p password -pl hello-dolly/hello.php
```

### 🧩 Arguments

```text
usage: 
CVE-2025-30911.py [-h] -u URL -un USERNAME -p PASSWORD [-pl PLUGIN]

Exploit For CVE-2025-30911 | By Nxploited Khaled Alenazi

options:
  -h, --help            Show this help message and exit
  -u, --url URL         Base URL of the WordPress site
  -un, --username USERNAME   WordPress admin username
  -p, --password PASSWORD    WordPress admin password
  -pl, --plugin PLUGIN       Plugin to install (default: hello-dolly/hello.php)
```

---

## 📝 Example

```bash
python3 CVE-2025-30911.py -u http://192.168.100.74:888/wordpress -un admin  -p admin -pl hello-dolly/hello.php

  
```

---

## 🔐 Requirements

- Python 3.x
- `requests` library (install via `pip install requests`)
- Valid WordPress Admin credentials
- Vulnerable RomethemeKit For Elementor plugin (<= 1.5.4) installed and active

---

## ⚠️ Disclaimer

This tool is provided **for educational and authorized security testing only**. Unauthorized use is illegal and unethical.

---

*By: Nxploited | Khaled Alenazi*
