
# 🚨 CVE-2025-30772 - Privilege Escalation in WPC Smart Upsell Funnel for WooCommerce <= 3.0.4

> 📅 Published: March 27, 2025  
> 🔐 CVSS Score: **8.8 (High)**  
> 🔥 CWE-862: Missing Authorization

---

## 🐞 Vulnerability Summary

A **Missing Authorization** vulnerability in the **WPC Smart Upsell Funnel for WooCommerce** plugin allows **authenticated users** with minimal privileges (e.g., `subscriber`) to **escalate their privileges** by modifying arbitrary WordPress options via a vulnerable AJAX endpoint.

This affects versions:
```
From: unknown  
Through: 3.0.4
```

---

## ⚠️ What Can Be Exploited?

The plugin registers the following unauthenticated-privileged AJAX endpoint:

```
action: wpcuf_import_export_save
```

This endpoint accepts a POST request and **calls `update_option()` directly** using values from the user without checking their permission.

---

## 💥 Real-World Impact

An attacker with a basic account (even subscriber) can:


. Modify this WordPress option:

| Option Name | Before Exploitation | After Exploitation |
|-------------|---------------------|---------------------|
| `default_role` | `subscriber` | `administrator` |

📌 After this, **any new user that registers** will become an **Administrator by default**.

---

## 🧪 Proof-of-Concept (PoC) Script

This script:

1. Logs in to the target WordPress site.
2. Extracts the `nonce` from the vulnerable admin page.
3. Sends a crafted request to modify `default_role` to `"administrator"`.

### 🔧 Usage

```bash
usage: CVE-2025-30772.py [-h] -u URL -un USERNAME -p PASSWORD

WordPress Privilege Escalation Exploit - CVE-2025-30772 # By Nxploited | Khaled ALenazi,

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     Target base URL
  -un USERNAME, --username USERNAME
                        WordPress username
  -p PASSWORD, --password PASSWORD
                        WordPress password
```

### 📂 Arguments

| Flag         | Description                  |
|--------------|------------------------------|
| `-u`         | Target WordPress base URL    |
| `-un`        | WordPress username           |
| `-p`         | WordPress password           |

---

## 📸 Visual Example

Before visiting:  
`http://target.com/wp-admin/options.php`

```
default_role = subscriber
```

After exploitation:  
```
default_role = administrator ✅
```

---

## 🛡️ Recommendation

Update the plugin immediately to a patched version once available.  
Until then, restrict access to `/wp-admin/admin-ajax.php` and monitor `default_role`.

---

## ✍️ About

This PoC was created by **Nxploited - Khaled Alenazi** for ethical and educational purposes only.



---





