# PoC for CVE-2025-30216: CryptoLib Heap Overflow Vulnerability

## Overview

CryptoLib provides a software-only solution using the CCSDS Space Data Link Security Protocol - Extended Procedures (SDLS-EP) to secure communications between a spacecraft running the core Flight System (cFS) and a ground station. In versions 1.3.3 and prior, a Heap Overflow vulnerability occurs in the `Crypto_TM_ProcessSecurity` function (`crypto_tm.c:1735:8`). When processing the Secondary Header Length of a TM protocol packet, if the Secondary Header Length exceeds the packet's total length, a heap overflow is triggered during the memcpy operation that copies packet data into the dynamically allocated buffer `p_new_dec_frame`. This allows an attacker to overwrite adjacent heap memory, potentially leading to arbitrary code execution or system instability.

**Impact**: A crafted packet can trigger heap memory corruption during `memcpy` operations into the `p_new_dec_frame` buffer, potentially leading to:
- Arbitrary code execution
- System instability
- Denial of Service

**Patched Version**: [810fd66d592c883125272fef123c3240db2f170f](https://github.com/nasa/CryptoLib/commit/810fd66d592c883125272fef123c3240db2f170f)

## Files

- `poc.py` - Dual-mode Python script:
  - **Generate** malicious TM packets
  - **Check** packets for vulnerability indicators

## Requirements

- Python 3.6+
- No external dependencies

## Usage

### 1. Generate Malicious Packet

```bash
./poc.py generate [overflow_amount]
```

**Parameters:**

- `overflow_amount`: Bytes to overflow (default: 1024)

**Example:**

```bash
# Generate packet with 2048-byte overflow
./poc.py generate 2048 > evil_packet.hex
```

### 2. Check Packet Vulnerability

```bash
./poc.py check <hex_packet>
```

**Parameters:**

- `<hex_packet>`: Hexadecimal string of TM packet

**Example:**

```bash
# Analyze generated packet
./poc.py check $(cat evil_packet.hex)
```

## Technical Details

### Packet Structure

```
[6-byte Primary Header][2-byte Secondary Header Length][Payload]
```

### Vulnerability Trigger

The script creates packets where:

- `Secondary Header Length > (Total Packet Length - Header Offset)`
- `memcpy` operation attempts to copy more bytes than available

### Detection Logic

```python
available_space = total_length - (offset + length_field_size)
if claimed_length > available_space:
    trigger_alert()
```

## Disclaimer

This software is intended for:

- Security research
- Vulnerability demonstration
- Defensive purposes

**Do NOT** use on production systems or without explicit authorization. The maintainers assume no liability for misuse of this tool.





