# CVE-2025-30065 Proof of Concept - Apache Parquet RCE

FOR EDUCATIONAL AND AUTHORIZED SECURITY RESEARCH ONLY.  
This PoC is provided as-is. The author is not responsible for misuse. Use only in environments where you have explicit permission.

## Description

This repository demonstrates an exploit path for CVE-2025-30065, a vulnerability in Apache Parquet's Avro schema handling. It focuses on the default value deserialization logic that can lead to unintended class instantiation, potentially resulting in code execution.

## Structure

- `ParquetExploitGenerator.java` – Generates a malicious Parquet file using a crafted Avro schema with default values that directly triggers instantiation of a standard Java class (`javax.swing.JEditorPane`).
- `PayloadRecord.java` – Payload class with a static initializer (legacy PoC component, now overwritten by the new logic).
- `ParquetVictim.java` – Simulated victim application that reads the Parquet file and deserializes the Avro schema, triggering the payload under the right conditions.

## Author

**@h3st4k3r** — VM, CTI & researcher  
https://github.com/h3st4k3r

## How It Works

1. The generator writes a `.parquet` file with an Avro schema that includes a default value.
2. The schema uses a standard Java class (`javax.swing.JEditorPane`) that has observable behavior when instantiated.
3. When the file is processed by a vulnerable deserialization routine (e.g., `AvroParquetReader`), it instantiates that class, potentially leading to side effects like outbound HTTP requests.

## Exploitation Requirements

- Avro deserialization of schemas with default values.
- Absence of strict deserialization filters or sandboxing.
- The referenced class (e.g., `JEditorPane`) must exist in the classpath.

## Build & Run

Use `run.sh` (included) to automate compilation, dependency resolution via Maven, and execution of the full chain.

Requirements:
- Java 8+
- Maven

```bash
chmod +x run.sh
./run.sh
```

## Real-World Implication

An attacker can craft a `.parquet` file containing a malicious schema and send it to a target system using vulnerable deserialization logic. If the target environment includes classes that can be abused via constructors or static initializers, code execution may be possible.

## Status

This PoC was originally conceptual and relied on a custom class. It has been updated to reflect the actual patch logic for CVE-2025-30065, as seen in:
- Apache's official patch diff
- Mouad Kondah’s PoC
- F5 Labs write-up
- Community feedback by @micrictor

The current version demonstrates the vulnerability using standard Java classes, without needing any custom payload class to be present in the classpath.

## Acknowledgements

Thanks to:
- **@micrictor** — for pointing out the difference between conceptual schema injection and the actual patch logic.
- **Mouad Kondah** — for the public PoC that followed the correct constructor path.
- **F5 Labs** — for documenting real-world implications and providing strong public visibility.
- Everyone contributing through discussion and responsible disclosure.

## Change History

### Initial Version
The original version of this PoC used a custom class named `PayloadRecord`, which was placed in the classpath of the victim application. The exploit relied on Avro's ability to instantiate this class through a default value in the schema. While this demonstrated the concept of deserialization-based RCE, it did not align precisely with the root cause addressed in the official Apache patch for CVE-2025-30065.

### Why It Changed
Following feedback from the community — particularly @micrictor — and deeper analysis of the patch and real-world PoCs, the generator was updated to reflect the true vulnerability pattern. This involved switching to a schema that references a standard Java class (`javax.swing.JEditorPane`) known to have instantiation side effects. This makes the PoC more accurate and practical, requiring no custom classes.

The goal is to ensure that the PoC not only demonstrates the general idea, but also aligns technically with the CVE as patched and documented in trusted sources.

## Summary

This PoC recreates the deserialization behavior that triggers CVE-2025-30065 under specific conditions. It does not depend on a custom payload class and follows the logic defined by the original patch. Use it responsibly, and only in controlled environments where you have permission.
