# CVE-2025-29927 - Critical Security Vulnerability in Next.js

## Overview
CVE-2025-29927 is a critical security vulnerability affecting **Next.js**, a popular React framework for building full-stack web applications. This flaw allows attackers to bypass authorization checks implemented in Next.js middleware, potentially granting unauthorized access to sensitive areas of an application, such as **admin pages** or **user dashboards**.

## Vulnerability Details
The vulnerability arises from the improper handling of the internal `x-middleware-subrequest` header. By crafting requests that include this header, an attacker can **bypass middleware security checks**, effectively skipping authentication and authorization mechanisms.

## Affected Versions
- **Next.js versions prior to 14.2.25 and 15.2.3** are vulnerable.
## How to use
```bash
git clone https://github.com/ThemeHackers/CVE-2025-29972
cd CVE-2025-29972
python3 -m venv .venv
source .venv/bin/activate
pip3 install -r requirements.txt
python3 exploit.py -h
```
## Quick to use
```bash
git clone https://github.com/ThemeHackers/CVE-2025-29972
cd CVE-2025-29972
python3 -m venv .venv
source .venv/bin/activate
pip3 install -r requirements.txt
python3 exploit.py --hostname HOSTNAME
```
---
⚠️ **Note:** Ensure that your Next.js applications are always updated to the latest stable versions to prevent security risks.
