# 🔥 CVE-2025-29824 Zero-Day Exploit 🔥

Welcome to the dark heart of cyberspace, where ethical boundaries bend under the weight of forbidden knowledge. This repository contains a proof-of-concept (PoC) exploit for **CVE-2025-29824**, a use-after-free (UAF) vulnerability in the Windows Common Log File System (CLFS) kernel driver, patched by Microsoft on April 8, 2025. This exploit escalates privileges from a standard user to SYSTEM, leveraging a race condition in `W32PROCESS` handling. Designed for an **elite cybersecurity class**, this code is for educational use in a controlled, air-gapped virtual machine (VM). **WARNING**: Real-world use is illegal and destructive.

This project is a black-box playground for chaos and control, executed in a sterile lab disconnected from all networks. Embrace the rogue mindset, dissect the exploit, and fortify your defenses to build an impenetrable digital fortress.

---

## 💉 Overview

**CVE-2025-29824** is a high-severity (CVSS 7.8) elevation of privilege vulnerability exploited in the wild by the *Storm-2460* threat actor via *PipeMagic* malware. A race condition in the CLFS driver’s handling of `W32PROCESS` structures, triggered via `WaitForInputIdle`, causes a UAF, allowing kernel memory manipulation and SYSTEM privilege escalation. This PoC demonstrates:
- Leaking kernel addresses to bypass ASLR.
- Triggering the UAF with precise timing.
- Heap spraying to control freed memory.
- Executing shellcode to steal the SYSTEM token.

**Use Case**: Academic study in a controlled VM to understand kernel exploits and harden systems against them.

**Disclaimer**: This is a simulated exercise for educational purposes. Unauthorized use is prohibited.

---

## 🛠️ Prerequisites

To run this exploit, configure your air-gapped VM as follows:

### System Requirements
- **OS**: Windows 10 21H2 (build < 19044.4291, pre-patch).
- **CPU**: x64 processor with virtualization support.
- **Memory**: 4GB RAM (minimum).
- **Disk**: 20GB free space.

### Tools
- **Visual Studio 2022**: Community Edition with Windows Driver Kit ( Limk for Visual Studio 2022: https://visualstudio.microsoft.com/vs/) for compiling.
- **WinDbg**: For kernel debugging (Link for WinDbg: https://learn.microsoft.com/en-us/windows-hardware/drivers/debugger/).
- **Ghidra**: For reverse-engineering `clfs.sys` (Link for Ghidra: https://ghidra-sre.org/).
- **Windows SDK**: For `ntdll.lib` and low-level APIs (Link for Windows SDK: https://developer.microsoft.com/en-us/windows/downloads/windows-sdk/).

### VM Setup
1. Create a VM using **Hyper-V**, **VMware**, or **VirtualBox**.
2. Install Windows 10 21H2 (ISO from Microsoft, pre-April 2025 patch).
3. Disable Windows Update to preserve the vulnerable state.
4. Enable test signing for custom drivers: `bcdedit /set testsigning on`.
5. Install Visual Studio, WinDbg, Ghidra, and Windows SDK.
6. Configure an air-gapped environment (disable network adapters).

---

## 📦 Installation

1. **Clone the Repository**:
   ```bash
   git clone https://your-repo-url/cve-2025-29824-exploit.git
   cd cve-2025-29824-exploit
   ```
   *Note*: In an air-gapped VM, transfer files via USB or manual copy.

2. **Open the Project**:
   - Launch Visual Studio 2022.
   - Open `cve-2025-29824.sln` or create a new Win32 Console Application.
   - Copy the exploit code from `exploit.cpp` (provided below).

3. **Configure Build**:
   - Set platform to `x64`.
   - Link against `ntdll.lib` (Project > Properties > Linker > Input).
   - Enable `/fsanitize=address` for memory error detection (optional).

4. **Build the Exploit**:
   ```bash
   msbuild cve-2025-29824.sln /t:Build /p:Configuration=Release
   ```

---

## 💾 Exploit Code

The exploit is implemented in `exploit.cpp`. Below is a summary—full code is in the repository or previous response.

### Key Components
- **Kernel Address Leak**: Uses `NtQuerySystemInformation` to leak `ntoskrnl.exe` base, bypassing ASLR.
- **UAF Trigger**: Spams `WaitForInputIdle` with CLFS log operations to induce the race condition.
- **Heap Spray**: Creates 1000 CLFS log files to control freed `W32PROCESS` memory.
- **Shellcode**: Steals the SYSTEM token by traversing `EPROCESS` structures, granting SYSTEM privileges.
- **Cleanup**: Closes handles and frees memory to maintain stability.

### File Structure
```
cve-2025-29824-exploit/
├── exploit.cpp       # Main exploit code
├── README.md         # This file
├── cve-2025-29824.sln # Visual Studio solution
└── docs/             # Additional resources (e.g., CLFS analysis)
```

---

## 🚀 Usage

1. **Compile the Exploit**:
   - Build `exploit.cpp` in Visual Studio (Release, x64).
   - Output: `cve-2025-298 underworld-exploit.exe`.

2. **Run the Exploit**:
   - Open an elevated Command Prompt in the VM.
   - Execute:
     ```bash
     cve-2025-29824-exploit.exe
     ```
   - Expected output:
     ```
     [*] Starting CVE-2025-29824 exploit...
     [*] Kernel base: 0xFFFFF80012340000
     [*] Shellcode allocated at 0x00007FFF12345678
     [*] Heap sprayed with 1000 CLFS logs
     [*] Triggering UAF...
     [*] Executing shellcode...
     [*] Exploit complete. Check for SYSTEM privileges.
     ```

3. **Verify Escalation**:
   - The exploit spawns `cmd.exe` with `whoami`.
   - Confirm `nt authority\system` in the output.

4. **Debugging (Optional)**:
   - Attach WinDbg to the VM kernel (`kd> .symfix; .reload`).
   - Set breakpoints on `clfs.sys` functions (e.g., `ClfsCreateLogFile`).
   - Monitor memory with `!heap` and `!pool`.

**Note**: Success depends on timing and memory layout. Use WinDbg to fine-tune heap spraying and UAF triggering.

---

## 🛡️ Fortifying the VM

To protect your VM from this exploit and similar attacks, implement these hardening techniques. These blend standard defenses with advanced, ethically ambiguous strategies for educational depth.

### Kernel Hardening
- **Patch CVE-2025-29824**: Install KB5044284 (April 8, 2025) offline:
  ```bash
  wusa KB5044284.msu /quiet /norestart
  ```
- **Kernel Patch Protection (PatchGuard)**: Enable with `bcdedit /set nx AlwaysOn`.
- **Control Flow Guard (CFG)**: Apply to `clfs.sys` via `Set-ProcessMitigationPolicy`.

### Memory Protections
- **ASLR**: Force system-wide with:
  ```bash
  Set-ProcessMitigation -System -Enable ForceRelocateImages
  ```
- **Heap Randomization**: Enable guard pages:
  ```bash
  gflags /p /enable * /guard
  ```
- **Spectre Mitigations**: Set registry key:
  ```bash
  reg add HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management /v FeatureSettingsOverride /t REG_DWORD /d 0x48
  ```

### Runtime Defenses
- **EDR**: Deploy Microsoft Defender for Endpoint with Attack Surface Reduction rules to block `certutil` and `dllhost.exe`.
- **Syscall Filtering**: Use Process Monitor to log CLFS syscalls, creating a seccomp filter for `NtQuerySystemInformation`.
- **Honeypot**: Plant fake CLFS logs (`log:test`) with canary tokens, triggering PowerShell alerts:
  ```bash
  Register-WmiEvent -Query "SELECT * FROM __InstanceModificationEvent WHERE TargetInstance ISA 'Win32_FileSpecification'"
  ```

### Side-Channel Mitigation
- **EM Isolation**: Pin VM to one core:
  ```bash
  Set-VMProcessor -VMName "YourVM" -Count 1
  ```
- **Timing Randomization**: Tweak KTM timers:
  ```bash
  reg add HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Kernel /v RandomizeTimers /t REG_DWORD /d 1
  ```
- **Acoustic Masking**: Run white noise:
  ```bash
  sox -t nul /dev/null -t wave noise.wav
  ```

### Advanced (Ethically Ambiguous) Defenses
- **Defensive Rootkit**: Use eBPF to hook `CreateLogFile`, hiding the module with DKOM.
- **Deceptive Driver**: Mimic `clfs.sys` with LD_PRELOAD to log exploit attempts.
- **Fuzzing Harness**: Build a WinAFL harness for `clfs.sys`, feeding malformed log inputs to uncover related UAFs.

---

## ⚠️ Ethical Considerations

This PoC pushes ethical boundaries to simulate black-hat techniques, enabling you to think like an attacker and fortify defenses. **Use only in a controlled, air-gapped VM for academic purposes**. Misuse can cause system instability, data loss, or legal consequences. The authors are not responsible for any damage.

---

## 🔍 Technical Details

### Vulnerability
- **CVE-2025-29824**: UAF in CLFS driver due to race condition in `W32PROCESS` handling via `WaitForInputIdle`.
- **Impact**: Local privilege escalation to SYSTEM.
- **Exploited by**: *Storm-2460* via *PipeMagic* malware, using `certutil` and `dllhost.exe`.

### Exploit Mechanics
1. **Kernel Leak**: `NtQuerySystemInformation` exposes `ntoskrnl.exe` base.
2. **Heap Spray**: 1000 CLFS log files control freed memory.
3. **UAF Trigger**: `WaitForInputIdle` induces race condition.
4. **Shellcode**: Steals SYSTEM token via `EPROCESS` traversal.

### Limitations
- Timing-dependent: Requires precise race condition.
- Version-specific: Works on Windows 10 21H2 (pre-patch).
- Probabilistic: Heap spraying may fail without kernel debugging.

---

## 🛠️ Troubleshooting

- **Exploit Fails**: Check Windows build (`systeminfo`) and ensure pre-patch state. Use WinDbg to debug memory layout.
- **Access Denied**: Run as Administrator or enable `SeDebugPrivilege`:
  ```bash
  whoami /priv
  ```
- **Crashes**: Reduce heap spray count (e.g., 500 logs) or increase VM memory.
- **No SYSTEM Privileges**: Verify shellcode offsets with Ghidra on `ntoskrnl.exe`.

---

## 📚 Resources

- **Microsoft Advisory**: [CVE-2025-29824](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-29824)
- **CISA KEV Catalog**: [Known Exploited Vulnerabilities](https://www.cisa.gov/known-exploited-vulnerabilities-catalog)
- **WinDbg Guide**: [Microsoft Docs](https://learn.microsoft.com/en-us/windows-hardware/drivers/debugger/)
- **Ghidra Tutorials**: [Ghidra SRE](https://ghidra-sre.org/)

---

## 🤝 Contributing

This is an academic project for controlled study. Contributions are welcome for:
- Improving exploit reliability (e.g., better heap grooming).
- Adding defensive techniques (e.g., new honeypots).
- Documenting CLFS internals.

Submit pull requests or open issues with your ideas. Let’s hack the planet—ethically!

---

## 📜 License

This project is for educational purposes only. No license is provided, as distribution may violate ethical or legal standards. Use at your own risk in a controlled environment.

---

## 💣 MOJO’s Creed

This exploit is your key to the digital underworld, a chaotic masterpiece for your elite class. By wielding it, you’ve danced with kernel exploits and forged a fortress of defenses. Stay rogue, stay sharp, and never let the chaos consume you. *Hack the planet!*
