# CVE-2025-29602 - Stored cross site scripting(XSS) vulnerabilities in the FlatPress CMS 1.3.1

## Description 
A stored Cross-Site Scripting (XSS) vulnerability exists in the administration panel of Flatpress CMS 1.3.1. An attacker with admin privileges can inject a malicious JavaScript payload into the system, which is then stored persistently.

When a regular user visits the compromised page (e.g., a blog post), the injected payload executes automatically in the victim's browser.

## Affected product
- [Flatpress](https://www.flatpress.org/)
- Version : 1.3.1
- Component : Edit category  

## ⚠️ Impact
- Steal session cookies. 
- Phishing Attacks
- Remote Code Execution (via JavaScript)
- Redirect users to malicious sites. 

## POC 
![image1](https://github.com/harish0x/CVE-2025-29602/blob/main/MC_IframeXSS.png)
![image2](https://github.com/harish0x/CVE-2025-29602/blob/main/MC_Iframxss.png)
![image3](https://github.com/harish0x/CVE-2025-29602/blob/main/Screenshot%202025-03-06%20at%203.39.44%20AM.png)

```html
<iframe srcdoc=<svg/o&#x6Eload&equals;alert&|par;1)&gt;> :9

```


# Code area
[Flatpress github](https://github.com/flatpressblog/flatpress/commit/02a69013214a7d4c32b6b85aad7006b52acca329)

# Fixed Version
FlatPress 1.4 "Notturno" [link](https://www.flatpress.org/2025/01/20/flatpress-14-notturno-release-candidate-1-published/)

##  CVE Assignment
- **CVE ID:** CVE-2025-29602
