
# CVE-2025-29556 – ExaGrid Security Officer Account Creation Bypass

## 📝 Overview

**Vulnerability Title**: Unauthorized Creation of Security Officer Account  
**Product**: ExaGrid EX10 Backup Appliance
**Version Affected**: Tested on current version at disclosure  
**Versions Affected**: 6.3 – 7.0.1.P08
**CVE ID**: CVE-2025-29556  
**Severity**: High  
**Attack Vector**: Authenticated, Low-Privileged Access  
**Impact**: Privilege Escalation to Security Officer Role

---

## 🧨 Description

This proof-of-concept (PoC) demonstrates a critical flaw in ExaGrid's API that allows a low-privileged or hijacked session to create **Security Officer** accounts without proper validation or authorization. The attacker must possess a valid `JSESSIONIDSSO` cookie and the `site UUID`.

The vulnerability enables **privilege escalation** and full administrative control over backup operations, user creation, encryption settings, and more.

---

## 🚀 Usage

### ⚙️ Prerequisites

- Python 3.x
- `requests` library (`pip install requests`)
- Valid:
  - `JSESSIONIDSSO` cookie
  - `site UUID`

### 📌 Command

```bash
python3 create_security_officer.py --url 10.0.0.5 --cookie YOUR_JSESSIONIDSSO --uuid YOUR_SITE_UUID
```

Add `--debug` to view the raw response:
```bash
python3 create_security_officer.py --url 10.0.0.5 --cookie abc123def456 --uuid a1b2c3d4 --debug
```

---

## 🧾 What It Does

- Sends a `POST` request to the `/api/v1/sites/{uuid}/users` endpoint
- Bypasses intended controls and creates a new user:
  - **Username**: `Security_Officer_BYPASSED`
  - **Group**: `exagrid-sec-offs`
  - **Password**: base64-encoded (example: `XTNhXmJeKHo/P0hdTSY=`)

---

## 🔐 Impact

- Bypasses access controls around Security Officer account creation
- Grants highest-level access within the backup appliance
- Can result in backup manipulation, policy tampering, and sensitive data access

---

## 🛡️ Mitigation

- Patch when a fix becomes available from ExaGrid
- Monitor for unexpected users in the `exagrid-sec-offs` group
- Invalidate suspicious or stale sessions
- Limit access to internal management interfaces

---

## 👨‍💻 Author

Security Researcher – Kevin Suckiel -- 0xsu3ks
PoC for CVE-2025-29556 disclosed through responsible channels.

---

## ⚠️ Legal Notice

This tool is intended **for authorized testing and research purposes only**. The author takes **no responsibility for misuse or damage** caused by this code.
