# CVE-2025-2945_PoC
pgAdmin Proof of Concept

# pgAdmin Query Tool RCE (CVE-2025-2945) – Python Proof of Concept

⚠️ **Disclaimer**  
This repository contains a proof-of-concept exploit for CVE-2025-2945, a critical remote code execution vulnerability in pgAdmin 4 versions prior to 9.2. Use this code **only** in environments you own or have explicit permission to test. The author is not responsible for any misuse or damage caused by this software.

---

## Table of Contents

1. [Overview](#overview)  
2. [Vulnerability Details (CVE-2025-2945)](#vulnerability-details-cve-2025-2945)  
3. [Prerequisites](#prerequisites)  
4. [Setup & Installation](#setup--installation)  
5. [Usage](#usage)  
6. [Exploit Workflow](#exploit-workflow)  
7. [Detection & Mitigation](#detection--mitigation)  
8. [License](#license)  

---

## Overview

This repository provides a standalone Python script—`pgadmin_rce.py`—that replicates the functionality of the Metasploit module for CVE-2025-2945. When run against a vulnerable pgAdmin 4 instance (versions 8.10–9.1), it will:

1. Authenticate to pgAdmin 4 using valid credentials.  
2. Initialize the Query Tool (SQL editor) session.  
3. Discover a valid server‐connection ID (server group & server ID).  
4. Submit a malicious payload via the `query_commited` parameter to trigger an `eval()` on the server.  
5. Observe an HTTP 500 response (indicating the payload executed on the backend).

Because the vulnerable endpoints rely on Python’s built-in `eval()` without sanitizing user input, an authenticated user can force pgAdmin to run **arbitrary Python code** on the host machine, resulting in full RCE.

---

## Vulnerability Details (CVE-2025-2945)

- **Affected Software**:  
  - pgAdmin 4 versions **8.10** through **9.1** (inclusive)  
- **Fixed In**:  
  - pgAdmin 4 version **9.2** (released April 4, 2025)  
- **CVSS v3.1 Score**: 9.9 (Critical)  
- **Impact**:  
  - An authenticated attacker can send a specially crafted `query_commited` (or `high_availability` in the Cloud Deployment module) parameter to an `eval()` call on the server, resulting in arbitrary code execution under the pgAdmin service account.  
- **References**:  
  - [Mitre CVE-2025-2945](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-2945)  
  - [NVD Entry (CVSS 9.9)](https://nvd.nist.gov/vuln/detail/CVE-2025-2945)  
  - [Tenable Analysis](https://www.tenable.com/security/research/tra-2025-2945)  
  - [Rapid7 Metasploit Module](https://github.com/rapid7/metasploit-framework/tree/master/modules/exploits/multi/http/pgadmin_query_tool_rce)  

---

## Prerequisites

1. **Python 3.7+**  
2. Python packages (install via `pip`):  
   - `requests`  
   - `faker`  

   ```bash
   pip install requests faker
