# CVE-2025-29384 Proof-of-Concept Exploit

## Overview
This repository contains an advanced proof-of-concept (PoC) exploit for **CVE-2025-29384**, a critical **stack-based buffer overflow** vulnerability discovered in the **Tenda AC9** router running firmware version **V15.03.05.14_multi**. This vulnerability allows **unauthenticated remote attackers** to crash the router’s web server (**Denial-of-Service, DoS**) and potentially execute arbitrary code (**Remote Code Execution, RCE**).

The purpose of this project is to **demonstrate exploit development skills**, contribute to the cybersecurity community, and provide an educational showcase for academic evaluations (e.g., cybersecurity scholarships).
This repository contains an advanced proof-of-concept (PoC) exploit for **CVE-2025-29384**, a critical **stack-based buffer overflow** vulnerability discovered in the **Tenda AC9** router running firmware version **V15.03.05.14_multi**. This vulnerability allows **unauthenticated remote attackers** to crash the router’s web server (**Denial-of-Service, DoS**) and potentially execute arbitrary code (**Remote Code Execution, RCE**).

The purpose of this project is to **demonstrate exploit development skills**, contribute to the cybersecurity community, and provide an educational showcase for academic evaluations, such as cybersecurity scholarships.

## Vulnerability Details

### CVE Description
CVE-2025-29384 affects the **Tenda AC9** router’s **web management interface**, specifically the endpoint:

```
/goform/AdvSetMacMtuWan
```

The vulnerability exists due to **improper bounds checking** on the `wanMTU` parameter, which is processed via an **HTTP POST request**. The input is copied into a **fixed-size stack buffer without validation**, leading to a classic **stack-based buffer overflow**.

#### **Impact**
- **Denial-of-Service (DoS)**: Crashes the router’s HTTP server, making it unresponsive until a reboot.
- **Potential RCE**: An attacker could **overwrite the return address** and execute arbitrary code on the router’s **MIPS-based architecture**.
- **No Authentication Required**: The vulnerability can be triggered remotely without credentials, increasing its severity.

#### **Technical Breakdown**

The vulnerable function (hypothetical reconstruction) follows this structure:

```c
void process_mtu(char *input) {
    char buffer[256];  // Fixed-size stack buffer
    strcpy(buffer, input);  // No length check, causes overflow
    // Process MTU value...
}
```

An attacker sending an oversized payload (e.g., 1024+ bytes) **overwrites adjacent memory**, including the **function’s return address**, potentially leading to **code execution**.

### **CVSS v3.1 Score: 9.8 (Critical)**
| Metric                | Value |
|----------------------|-------|
| **Attack Vector**    | Network |
| **Attack Complexity** | Low |
| **Privileges Required** | None |
| **User Interaction** | None |
| **Confidentiality Impact** | High |
| **Integrity Impact** | High |
| **Availability Impact** | High |

## Affected Device

The **Tenda AC9** is a **dual-band wireless router** with the following specifications:

- **CPU**: Broadcom BCM4708 (MIPS 74Kc, dual-core, ~1 GHz)
- **RAM**: 128 MB
- **Flash**: 16 MB
- **Wi-Fi**: Dual-band 802.11ac (AC1200)
- **Ports**: 1x Gigabit WAN, 4x Gigabit LAN
- **Firmware**: **V15.03.05.14_multi** (confirmed vulnerable)

## Disclosure Timeline

- **March 14, 2025** – CVE-2025-29384 published on **NVD/MITRE**.
- **March 17, 2025** – This PoC developed and tested.
- **March 17, 2025** – No official patch from Tenda as of this date.

## PoC Exploit Details

### Ruby Metasploit Module
This repository also includes a **Ruby-based Metasploit module** for CVE-2025-29384. The module integrates seamlessly with the Metasploit Framework, allowing you to exploit the vulnerability using `msfconsole`.

### How to Use the Ruby Module
#### **Step 1: Download the Module**
```bash
git clone https://github.com/Otsmane-Ahmed/cve-2025-29384-poc
cd cve-2025-29384-poc
```

#### **Step 2: Copy the Module to Metasploit**
Locate the **Ruby module file** and copy it to Metasploit's exploits directory:
```bash
cp tenda_ac9_stack_overflow.rb ~/.msf4/modules/exploits/linux/http/
```

**Note:** If the directory does not exist, create it:
```bash
mkdir -p ~/.msf4/modules/exploits/linux/http/
```

#### **Step 3: Launch Metasploit**
Start Metasploit Framework:
```bash
msfconsole
```

Load the module:
```bash
use exploit/linux/http/tenda_ac9_stack_overflow
```

#### **Step 4: Configure and Run the Exploit**
Set the target IP address:
```bash
set RHOSTS <target_ip>
```

Set the payload size (optional, default is 1024):
```bash
set PAYLOAD_SIZE 2048
```

Run the exploit:
```bash
run
```

### **Example Output**
```
[*] Targeting Tenda AC9 at 192.168.0.1:80...
[*] Sending payload of size 2048...
[+] Payload sent successfully!
[*] Response: HTTP/1.1 200 OK...
```

### **Expected Results**
 **Success**: The router’s web server crashes, causing a **Denial-of-Service (DoS) condition**.  
 **Failure**: The router remains operational, indicating it may not be vulnerable or is running a patched firmware version.



### **Exploit Overview**
This PoC is a **Python-based exploit** that sends oversized input to `/goform/AdvSetMacMtuWan`, triggering a buffer overflow to **crash the web server** and showcasing potential for RCE.

### **Tested Environment**
- **Operating System**: Kali Linux
- **Python Version**: 3.x
- **Test Device**: Tenda AC9 (Firmware V15.03.05.14_multi)

### **Features**
 **Multithreading** – Launches multiple concurrent exploit attempts for reliability.
 
 **Dynamic Payloads** – Generates randomized base64-encoded attack strings.
 
 **Logging** – Uses Python’s logging module for structured debugging.
 
 **Customizable Parameters** – Adjusts **target IP, payload size, and thread count**.

### **Exploit Overview**
This PoC is a **Python-based exploit** that sends oversized input to `/goform/AdvSetMacMtuWan`, triggering a buffer overflow to **crash the web server**.

### **Usage**

#### **Prerequisites**
- **Python 3.x**
- **Tenda AC9 router with V15.03.05.14_multi firmware**



#### **Running the Exploit**
```bash
python poc.py --target <router_ip> --size 2048 --threads 10
```

##### **Arguments:**
| Argument | Description |
|----------|-------------|
| `--target` | Router IP (default: `192.168.0.1`) |
| `--size` | Payload size in bytes (default: `1024`) |
| `--threads` | Number of concurrent threads (default: `5`) |

#### **Example Output**
```
[+] CVE-2025-29384 Exploit Engine
[INFO] Target: 192.168.0.1
[INFO] Sending payload (2048 bytes)...
[WARNING] Target timeout - possible crash!
[INFO] Exploit sequence completed.
```

### **Expected Results**
 **Success**: Router’s web interface becomes unresponsive (**DoS condition**).
 
 **Failure**: The router still responds (**not vulnerable or wrong firmware**).

 

## Verification
To confirm that the exploit successfully crashes the router, attempt to reload the web interface. If it becomes unresponsive, the attack was successful. For further analysis, check network logs for dropped connections or use `ping` to verify device responsiveness.

## Disclaimer
This project is for **educational and ethical hacking purposes only**. Unauthorized use of this exploit **is illegal**. The author **is not responsible** for misuse or damage caused by this code.

**Developed with ❤️ by Otsmane Ahmed**
This project is for **educational and ethical hacking purposes only**. Unauthorized use of this exploit **is illegal**. The author **is not responsible** for misuse or damage caused by this code.

## License
This project is released under the **MIT License**.
