# CVE-2025-2907 Exploit 

### Details

- **Published**: 2025-04-04
- **Updated**: 2025-03-28
- **Severity**: Critical (CVSS Score: 9.8 )
- **CWE**: CWE-862: CWE-862 Missing Authorization
- **Affected Versions**: All versions from n/a through 12.3.1
- **Researcher**: [https://www.wordfence.com/threat-intel/vulnerabilities/researchers/mike-gozdiskowski](https://www.wordfence.com/threat-intel/vulnerabilities/researchers/mike-gozdiskowski)

### CVSS Vector

- **CVSS Version**: 9.8
- **Vector String**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H

## Description

The Order Delivery Date for WooCommerce plugin for WordPress is vulnerable to unauthorized modification of data that can lead to privilege escalation due to a missing capability check on the 'orddd-import-file' action in versions 2.0 to 12.3.1 (exclusive). This makes it possible for unauthenticated attackers to update arbitrary options on the WordPress site. This can be leveraged to update the default role for registration to administrator and enable user registration for attackers to gain administrative user access to a vulnerable site. Please note this only affects the PRO version of the software.

### Usage

```sh
usage: python3 CVE-2025-2907.py
```

## Script Details

### Installation

1. Clone the repository:
    ```sh
    git clone https://github.com/Yucaerin/CVE-2025-2907.git
    cd CVE-2025-2907
    pip3 install -r requirements.txt
    ```
   
## Disclaimer

This script is intended for educational purposes only. Use it responsibly and only on systems for which you have explicit permission. Unauthorized use of this script is illegal and unethical.
