---

# CVE-2025-29018 - Internet Banking System 2.0.0 Stored XSS in pages_add_acc_type.php

## Description
A **Stored Cross-Site Scripting (XSS)** vulnerability exists in **Code Astro Internet Banking System 2.0.0** due to **unsanitized input** in the `name` parameter in `pages_add_acc_type.php`. Attackers can store malicious JavaScript that executes whenever the page is loaded.

## Affected Component
- `name` parameter in `pages_add_acc_type.php`
- JavaScript executes on admin panel view

## Exploitation Steps
1. Navigate to **"Add Acc Type"**.

<img src="https://github.com/user-attachments/assets/f70e737f-7cb0-4692-9cf4-3fd5c77e8d55" width="100%" height="100%"><br>

2. Enter the following payload in the Account Category Name `(name parameter)` field and submit the form:

```html
   b1tm4rxss<script>alert("b1tm4r XSS");</script>
```
<img src="https://github.com/user-attachments/assets/8712ee5b-bc53-46fd-96bf-953fd3d22641" width="100%" height="100%"><br><br>
<img src="https://github.com/user-attachments/assets/b7270db3-b67b-46b1-b9af-8e6f794021fd" width="100%" height="100%"><br><br>
<img src="https://github.com/user-attachments/assets/6c050db4-ac52-4786-93ff-b926fa1c477b" width="100%" height="100%"><br>

3. When an admin or user visits the Manage Acc Types menu, payload will trigger.

<img src="https://github.com/user-attachments/assets/194bc131-bc40-45c8-9de6-75e4689aa853" width="100%" height="100%"><br>

Impact
- Session Hijacking
- Credential Theft
- Account Takeover

Mitigation
- Implement HTML entity encoding for user input.
- Use CSP to prevent inline script execution.
- Validate and sanitize all input fields.

References
- CWE-79: Improper Neutralization of Input
