---

# CVE-2025-29015 - Internet Banking System 2.0.0 Stored XSS in pages_account.php

## Description
A **Stored Cross-Site Scripting (XSS)** vulnerability exists in **Code Astro Internet Banking System 2.0.0** via the `name` parameter in `/admin/pages_account.php`. Malicious JavaScript code can be injected and stored in the system, executing whenever an admin views the affected page. This can lead to **session hijacking** and other client-side attacks.

## Affected Component
- `name` parameter in `/admin/pages_account.php`
- Data is stored and executed when accessed by an admin

## Exploitation Steps
1. Log in to the admin panel and navigate to the **"Account"** section.

<img src="https://github.com/user-attachments/assets/f75d6c2f-32da-47e7-8f55-01d92e2fe6d9" width="100%" height="100%"><br>

3. Insert the following payload in the `name` field and submit the form:

```html
   //--></SCRIPT>">'><SCRIPT>alert(String.fromCharCode(98, 49, 116, 109, 52, 114));</SCRIPT>
```
<img src="https://github.com/user-attachments/assets/67e668dc-b407-43d4-b53d-db44ff067d89" width="100%" height="100%">

3. When the user visits any page or menu, the payload will trigger.

<img src="https://github.com/user-attachments/assets/84044999-3bba-492c-b7bf-35df3f61451e" width="100%" height="100%"><br><br>
<img src="https://github.com/user-attachments/assets/0c5f3bfe-6022-42ba-8cb1-7874a663dec4" width="100%" height="100%"><br><br>
<img src="https://github.com/user-attachments/assets/fb2c0b44-8868-4359-b669-f9814453e591" width="100%" height="100%"><br>

Impact

- Session Hijacking
- Phishing Attacks
- Arbitrary Actions on Behalf of an Admin

Mitigation

- Implement proper input sanitization (e.g., escaping special characters).
- Use Content Security Policy (CSP) to limit script execution.
- Validate and encode user input before storing it.

References

- OWASP XSS Guide
