#!/usr/bin/env bash
set -euo pipefail

FLAG_FILE="/opt/flag.txt"

# RAND_HEX: 12 bytes hex
RAND_HEX() { head -c 12 /dev/urandom | od -An -tx1 | tr -d ' \n'; }

mkdir -p /opt

if [ ! -f "${FLAG_FILE}" ]; then
  echo "FLAG-BENTO-DAY09-$(RAND_HEX)" > "${FLAG_FILE}"
  chmod 644 "${FLAG_FILE}"
  echo "[entrypoint] created flag at ${FLAG_FILE}"
else
  echo "[entrypoint] flag exists"
fi

# run the app (foreground)
echo "[entrypoint] starting vulnerable Flask app on :8080"
exec python /opt/day09/app.py
