# Below Privilege Escalation Exploit (CVE-2025-27519)

This repository contains a proof-of-concept (PoC) Bash script to exploit the **Below privilege escalation vulnerability** (CVE-2025-27519) on Linux systems. The exploit allows a local user to escalate privileges to **root** by abusing the way the `below` binary logs errors.

> ⚠️ **Warning:** This script is intended for **educational purposes and authorized penetration testing only**. Do **not** use it on systems you do not own or have permission to test.

---

## Overview of the Vulnerability

- **CVE:** CVE-2025-27519  
- **Affected software:** `below` logging utility  
- **Impact:** Local privilege escalation  
- **Description:** The `below` binary improperly handles error logging and file locks. Its log directory (`/var/log/below/`) is **globally writable**, allowing any local user to manipulate log files. By creating a symlink from `error_root.log to` `/etc/ passwd` and triggering `below error`, an attacker can insert a fake root user entry and gain administrative privileges. 

**Why it works:**  
1. `below` writes errors to `/var/log/below/error_root.log`.
2. The log directory /var/log/below/ is world-writable (drwxrwxrwx), allowing any local user to replace or symlink the log file.
3. The program does not properly check file ownership and permissions before writing.  
4. By replacing the log file with a symlink to `/etc/passwd`, the script can insert a fake root user entry
5. after triggering an error low priv user can able to create fake user inside `/etc/passwd`
---

## Usage

1. **Clone the repository:**
   ```bash
   git clone https://github.com/Diabl0xE/CVE-2025-27519
   cd CVE-2025-27519
2. **Make the script executable:**
   ```bash
   chmod +x exploit.sh
3. **Run the exploit:**
   ```bash
   ./exploit.sh
