# CVE-2025-27515 Proof of Concept

A practical demonstration of **CVE-2025-27515**, a file upload validation bypass vulnerability in Laravel Framework (≤ 12.0.0).

## Vulnerability Overview

**CVE-2025-27515** is a validation bypass that allows attackers to circumvent file upload restrictions when Laravel applications use wildcard validation patterns (`files.*`). The vulnerability enables uploading of malicious files by exploiting weaknesses in how Laravel processes array-based file uploads.

**Severity:** Medium/High  
**CWE:** CWE-20 (Improper Input Validation)

### Attack Vector

The exploit uses a **polyglot JPEG+PHP file** that:
- Contains valid JPEG magic bytes (`FF D8 FF E0`) to bypass MIME type validation
- Includes embedded PHP code (`<?php system($_GET['cmd']); ?>`)
- Uses `.jpg` extension to pass file extension checks

## Quick Start

### Run the Vulnerable Application

```bash
php artisan serve
# Access at http://localhost:8000/upload
```

### Execute the Exploit

**Python version:**
```bash
pip3 install -r requirements.txt
python3 exploit.py http://localhost:8000
```

## ⚠️ Disclaimer

**FOR EDUCATIONAL AND AUTHORIZED SECURITY TESTING ONLY**

- This is an intentionally vulnerable environment
- Do not use in production systems
- Only test on systems you own or have explicit permission to test
- Unauthorized access to computer systems is illegal

## References

- [NVD - CVE-2025-27515](https://nvd.nist.gov/vuln/detail/CVE-2025-27515)
- [Laravel Security](https://laravel.com/docs/security)
- [OWASP File Upload Security](https://owasp.org/www-community/vulnerabilities/Unrestricted_File_Upload)

---

**By CatSec** | Cyber Security Research
