# CVE-2025-27415 PoC #
---
## Nuxt3 cache poisoning ##

nuxt3 >=3.0.0 <3.16.0 에서 발생한 cache poisoning 취약점 환경 세팅을 위한 레포지토리

---
## 취약점 요약 ##

nuxt 서버 앞에 CDN이 있을 때 CDN에서 URL 쿼리를 제외한 경로만 캐시키로 저장할 때 ``/?/_payload.json``에 대한 요청이 ``/``까지만 캐시키로 저장되어서
다른 사용자가 ``/``에 대해 요청을 보내면 정상 페이지가 아닌 ``_payload.json``에 대한 응답이 캐시에서 반환되는 취약점

공격자가 캐시가 사라지는 주기마다 ``/?/_payload.json``에 요청을 보내면 다른 사용자가 정상적인 페이지를 반환받을 수 없게 되는 DoS 취약점이 유발될 수 있다.

#### 자세한 설명 및 분석 ####

<https://preo123.tistory.com/19>

---
## SetUp ##

```bash
git clone https://github.com/jiseoung/CVE-2025-27415-PoC.git
cd CVE-2025-27415-PoC
docker-compose up --build
```
---
## 페이지 설명 ##

* '/' : cache poisoning을 유도하기 위한 페이지
  실제로 ``http://localhost/?/_payload.json``으로 요청을 보내 '/' 경로에 대한 캐시를 생성하면 ``http://localhost/``로 접근했을 때 '/' 페이지에 대한 응답이 반환되지 않고 캐시에 저장된 ``_payload.json``의 내용이 json으로 반환된다.

* '/ex' : cache poisoning 공격을 자동으로 수행해주는 페이지
  
  * Target Origin : cache poisoning 공격을 수행할 경로
    
    이 환경에서는 호스트에 nginx 컨테이너인 nuxt-nginx를 써야 한다. 왜냐하면 공격 자동화 서버를 다른 컨테이너에서 Flask로 구축했기 때문에 localhost로 보내면 해당 컨테이너의 localhost로 인식한다.
    
  * Cache Interval : 요청을 보낼 주기(초). CDN의 캐시가 사라지는 주기보다 약간 짧게 설정한다.
    
    이 환경에서는 60초동안 요청을 캐시에 저장한다.
